/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */
'use strict';

Vtiger_Detail_Js(
	'ReportTemplate_Detail_Js',
	{
		generateReport(id) {
			AppConnector.request({
				module: 'ReportTemplate',
				action: 'GenerateReport',
				record: id
			})
				.done((data) => {
					if (data.result.success) {
						const link = document.createElement('a');
						link.href = data.result.file;
						link.click();
						app.showNotify({
							type: 'success',
							text: data.result.message
						});
					} else {
						app.showError({
							title: app.vtranslate('JS_ERROR'),
							text: data.result.message
						});
					}
				})
				.fail(function (_error) {
					app.showError({
						title: app.vtranslate('JS_ERROR')
					});
				});
		}
	},
	{
		getPreview: function (previewData, previewHeadersData) {
			AppConnector.request({
				module: app.getModuleName(),
				view: 'Preview',
				previewData: previewData,
				previewHeadersData: previewHeadersData
			}).done((data) => {
				$('.js-report-preview').html(data);
			});
		},
		fetchPreviewDataAjax: function () {
			return new Promise((resolve, _reject) => {
				AppConnector.request({
					module: app.getModuleName(),
					action: 'FetchPreviewDataAjax',
					reportId: app.getRecordId()
				}).done(({ result }) => {
					this.getPreview(result.previewData, result.previewHeadersData);
					resolve(result);
				});
			});
		},
		registerBasicEvents: function () {
			this._super();
			this.fetchPreviewDataAjax();
		}
	},
	{}
);
