'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";jQuery.Class("Settings_CustomView_Index_Js",{},{container:!1,contents:!1,/**
		 * Register events
		 * @param {jQuery} container
		 */initEvents:function initEvents(container){var _this=this;container.on("click",".js-delete-filter",function(e){_this.deleteFilter(e);}),container.on("change",".js-update-field",function(e){_this.updateField(e);}),container.on("click",".js-update,.js-create-filter",function(e){_this.update(e);}),container.on("change",".js-module-filter",function(e){_this.registerFilterChange(e);});},/**
		 * Load form to edit filter
		 * @param {jQuery.Event} e
		 */update:function update(e){var target=$(e.currentTarget),editUrl=target.data("editurl");new CustomView(editUrl);},/**
		 * Update parameter
		 * @param {jQuery.Event} e
		 */updateField:function updateField(e){var thisInstance=this,target=$(e.currentTarget),closestTrElement=target.closest(".js-filter-row");$.progressIndicator({message:app.vtranslate("JS_SAVE_LOADER_INFO"),blockInfo:{enabled:!0}});var params={cvid:closestTrElement.data("cvid"),mod:closestTrElement.data("mod"),name:target.attr("name"),value:target.val()};app.saveAjax("updateField",{},params).done(function(){thisInstance.getContainer().find(".js-module-filter").trigger("change");});},/**
		 * Delete filter
		 * @param {jQuery.Event} e
		 */deleteFilter:function deleteFilter(e){var thisInstance=this,target=$(e.currentTarget),closestTrElement=target.closest(".js-filter-row");$.progressIndicator({message:app.vtranslate("JS_SAVE_LOADER_INFO"),blockInfo:{enabled:!0}}),app.saveAjax("delete",{},{cvid:closestTrElement.data("cvid")}).done(function(){thisInstance.getContainer().find(".js-module-filter").trigger("change");});},/**
		 * Function to regiser the event to make the filters sortable
		 */makeFilterListSortable:function makeFilterListSortable(container){var thisInstance=this,tbody=container.find("tbody");1<tbody.children().length&&tbody.each(function(){jQuery(this).sortable({containment:"tbody",revert:!0,tolerance:"pointer",cursor:"move",helper:function helper(e,ui){return ui.children().each(function(index,element){element=jQuery(element),element.width(element.width());}),ui},update:function update(){thisInstance.updateSequence();}});});},/**
		 * Update sequences
		 */updateSequence:function updateSequence(){var sequences=[];this.getContents().find(".js-filter-row").each(function(n,row){var cvId=$(row).data("cvid");sequences.push(cvId);}),app.saveAjax("upadteSequences",sequences).done(function(data){data.success&&app.showNotify({text:data.result.message,type:"success"});});},/**
		 * Load list of filter for module
		 * @param {jQuery.Event} e
		 */registerFilterChange:function registerFilterChange(e){var thisInstance=this,aDeferred=$.Deferred(),progress=$.progressIndicator({message:app.vtranslate("JS_LOADING_PLEASE_WAIT"),blockInfo:{enabled:!0}}),params={module:app.getModuleName(),view:app.getViewName(),parent:app.getParentModuleName(),sourceModule:$(e.currentTarget).val()};return AppConnector.requestPjax(params).done(function(data){var contents=thisInstance.getContents().html(data);thisInstance.makeFilterListSortable(contents),thisInstance.getContainer().find(".js-create-filter").data("editurl",contents.find("#js-add-filter-url").val()),progress.progressIndicator({mode:"hide"}),aDeferred.resolve(data);}).fail(function(){aDeferred.reject();}),aDeferred.promise()},getContainer:function getContainer(){return !1==this.container&&(this.container=jQuery("div.contentsDiv")),this.container},getContents:function getContents(){return !1==this.contents&&(this.contents=this.getContainer().find(".indexContents")),this.contents},/**
		 * Main function
		 */registerEvents:function registerEvents(){var container=this.getContainer();this.initEvents(container),this.makeFilterListSortable(container);}});
//# sourceMappingURL=Index.min.js.map
