'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";$.Class("Base_SortOrderModal_JS",{},{/**
		 * Modal container
		 */container:!1,/**
		 * Source container
		 */sourceContainer:!1,/**
		 * Modal ID
		 */source:!1,/**
		 * Load data
		 */loadData:function loadData(){var orderBy=this.sourceContainer.find("#orderBy").val();if(orderBy=orderBy?JSON.parse(orderBy):[],orderBy&&Object.keys(orderBy).length){var baseOrderBy=this.container.find(".js-base-element");for(var field in orderBy)if(baseOrderBy.find("option[value='"+field+"']").length){var element=this.addRow();element.find("select.js-orderBy").val(field).change();var sortIcon=element.find(".js-sort-icon-active");orderBy[field]&&sortIcon.data("val")!=orderBy[field]&&sortIcon.trigger("click");}}else this.addRow();},/**
		 * Add new row
		 */addRow:function addRow(){var sortContainer=this.container.find(".js-base-element").clone(!0,!0).removeClass("js-base-element");return this.container.find(".js-sort-container").append(sortContainer),App.Fields.Picklist.showSelect2ElementView(sortContainer.find("select")),sortContainer.removeClass("d-none")},/**
		 * Register list events
		 */registerListEvents:function registerListEvents(){var _this=this;this.container.find(".js-add").on("click",function(){_this.addRow();}),this.container.find(".js-clear").on("click",function(e){$(e.currentTarget).closest(".js-sort-container_element").remove();}),this.container.find(".js-sort-order-button").on("click",function(e){var element=$(e.currentTarget).closest(".js-sort-container_element");element.find(".js-sort-icon").toggleClass("d-none js-sort-icon-active"),element.find(".js-sort-order").val(element.find(".js-sort-icon-active").data("val"));}),this.container.find(".js-modal__save").on("click",function(e){e.preventDefault(),_this.sourceContainer.find(".js-list-reload").trigger("click",{orderby:_this.getSortData()}),app.hideModalWindow(null,_this.source);});},/**
		 * Gets sort data
		 */getSortData:function getSortData(){var sortData={};return this.container.find(".js-sort-container_element:not(.js-base-element)").each(function(){var orderBy=$(this).find(".js-orderBy").val();orderBy&&(sortData[orderBy]=$(this).find(".js-sort-order").val());}),sortData},/**
		 * Gets basic container
		 */getSourceContainer:function getSourceContainer(){return $("[data-modalid="+this.source+"]").closest(".listViewContentDiv,.relatedContainer,.js-main-container")},/**
		 * Register modal events
		 * @param {jQuery} modalContainer
		 */registerEvents:function registerEvents(modalContainer){this.container=modalContainer,this.source=modalContainer.closest(".js-modal-container").attr("id"),this.sourceContainer=this.getSourceContainer(),this.registerListEvents(),this.loadData();}});
//# sourceMappingURL=SortOrderModal.min.js.map
