'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 *************************************************************************************/"use strict";jQuery.Class("Vtiger_Base_Validator_Js",{moduleName:!1,/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field,rules,k,options){//If validation engine already maked the field as error
// we dont want to proceed
if("undefined"==typeof options||!0!==options.isError){var listOfValidators=Vtiger_Base_Validator_Js.getValidator(field);for(var i in listOfValidators){var validatorList=listOfValidators[i],validatorName=validatorList.name,validatorInstance=new validatorName,result=void 0;if(validatorInstance.setElement(field),result=validatorList.hasOwnProperty("params")?validatorInstance.validate(validatorList.params):validatorInstance.validate(),!result)return validatorInstance.getError()}}},/**
		 *Function which gets the complete list of validators based on type and data-validator
		 *@param accepts field element as parameter
		 * @return list of validators for field
		 */getValidator:function getValidator(field){var listOfValidators=[],fieldData=field.data(),fieldInfo=fieldData.fieldinfo;"string"==typeof fieldInfo&&(fieldInfo=JSON.parse(fieldInfo));var moduleEle=field.closest("form").find("[name=\"module\"]");!1===Vtiger_Base_Validator_Js.moduleName&&0<moduleEle.length&&(Vtiger_Base_Validator_Js.moduleName=moduleEle.val());var key,value,fieldInstance=Vtiger_Field_Js.getInstance(fieldInfo),validatorsOfType=Vtiger_Base_Validator_Js.getValidatorsFromFieldType(fieldInstance);for(key in validatorsOfType)//IE for loop fix
validatorsOfType.hasOwnProperty(key)&&(value=validatorsOfType[key],""!==value&&listOfValidators.push({name:value}));if(fieldData.hasOwnProperty("validator")){var specialValidators=fieldData.validator;for(var s in specialValidators)//IE for loop fix
if(specialValidators.hasOwnProperty(s)){var specialValidator=specialValidators[s],tempSpecialValidator=jQuery.extend({},specialValidator),validatorOfNames=Vtiger_Base_Validator_Js.getValidatorClassName(specialValidator.name);""!==validatorOfNames&&(tempSpecialValidator.name=validatorOfNames,!jQuery.isEmptyObject(tempSpecialValidator)&&listOfValidators.push(tempSpecialValidator));}}return listOfValidators},/**
		 *Function which gets the list of validators based on data type of field
		 *@param accepts fieldInstance as parameter
		 * @return list of validators for particular field type
		 */getValidatorsFromFieldType:function getValidatorsFromFieldType(fieldInstance){var fieldType=fieldInstance.getType(),validatorsOfType=[];return fieldType=fieldType.charAt(0).toUpperCase()+fieldType.slice(1).toLowerCase(),validatorsOfType.push(Vtiger_Base_Validator_Js.getValidatorClassName(fieldType)),validatorsOfType},getValidatorClassName:function getValidatorClassName(validatorName){var validatorsOfType="",className=Vtiger_Base_Validator_Js.getClassName(validatorName),fallBackClassName=Vtiger_Base_Validator_Js.getFallBackClassName(validatorName);return "undefined"==typeof window[className]?"undefined"!=typeof window[fallBackClassName]&&(validatorsOfType=window[fallBackClassName]):validatorsOfType=window[className],validatorsOfType},/**
		 *Function which gets validator className
		 *@param accepts validatorName as parameter
		 * @return module specific validator className
		 */getClassName:function getClassName(validatorName){var moduleName;return moduleName=!1==Vtiger_Base_Validator_Js.moduleName?app.getModuleName():Vtiger_Base_Validator_Js.moduleName,moduleName+"_"+validatorName+"_Validator_Js"},/**
		 *Function which gets validator className
		 *@param accepts validatorName as parameter
		 * @return generic validator className
		 */getFallBackClassName:function getFallBackClassName(validatorName){return "Vtiger_"+validatorName+"_Validator_Js"}},{field:"",error:"",/**
		 *Function which validates the field data
		 * @return true
		 */validate:function validate(){return !0},/**
		 *Function which gets error message
		 * @return error message
		 */getError:function getError(){return null==this.error?"Validation Failed":this.error},/**
		 *Function which sets error message
		 * @return Instance
		 */setError:function setError(errorInfo){return this.error=errorInfo,this},/**
		 *Function which sets field attribute of class
		 * @return Instance
		 */setElement:function setElement(field){return this.field=field,this},/**
		 *Function which gets field attribute of class
		 * @return Instance
		 */getElement:function getElement(){return this.field},/**
		 *Function which gets trimed field value
		 * @return fieldValue
		 */getFieldValue:function getFieldValue(){var field=this.getElement();return jQuery.trim(field.val())}});
//# sourceMappingURL=BaseValidator.min.js.map
