const EmojiProps = {
  native: {
    type: Boolean,
    default: false,
  },
  tooltip: {
    type: Boolean,
    default: false,
  },
  fallback: {
    type: Function,
  },
  skin: {
    type: Number,
    default: 1,
  },
  set: {
    type: String,
    default: 'apple',
  },
  emoji: {
    type: [String, Object],
    required: true,
  },
  size: {
    type: Number,
    default: null,
  },
  tag: {
    type: String,
    default: 'span',
  },
}

const PickerProps = {
  perLine: {
    type: Number,
    default: 9,
  },
  maxSearchResults: {
    type: Number,
    default: 75,
  },
  emojiSize: {
    type: Number,
    default: 24,
  },
  title: {
    type: String,
    default: 'Emoji Mart™',
  },
  emoji: {
    type: String,
    default: 'department_store',
  },
  color: {
    type: String,
    default: '#ae65c5',
  },
  set: {
    type: String,
    default: 'apple',
  },
  skin: {
    type: Number,
    default: null,
  },
  defaultSkin: {
    type: Number,
    default: 1,
  },
  native: {
    type: Boolean,
    default: false,
  },
  emojiTooltip: {
    type: Boolean,
    default: false,
  },
  autoFocus: {
    type: Boolean,
    default: false,
  },
  i18n: {
    type: Object,
    default() {
      return {}
    },
  },
  showPreview: {
    type: Boolean,
    default: true,
  },
  showSearch: {
    type: Boolean,
    default: true,
  },
  showCategories: {
    type: Boolean,
    default: true,
  },
  showSkinTones: {
    type: Boolean,
    default: true,
  },
  infiniteScroll: {
    type: Boolean,
    default: true,
  },
  pickerStyles: {
    type: Object,
    default() {
      return {}
    },
  },
}

export { EmojiProps, PickerProps }
