<?php

/**
 * OAuth authorization action file.
 *
 * @package Action
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

use App\Mail\Account\Repository;
use App\Mail\Account\Repository\AccountPrivateRepository;

/**
 * OAuth authorization action class.
 */
class Settings_OSSMailScanner_OAuth_Action extends Settings_Vtiger_Basic_Action
{
	/** {@inheritdoc} */
	public function checkPermission(App\Request $request)
	{
		parent::checkPermission($request);
		$recordId = $request->getInteger('record');
		$mailAccount = \App\Mail\Account::getInstanceById($recordId);

		if ($mailAccount?->isPrivate()) {
			throw new \App\Exceptions\NoPermitted('LBL_PERMISSION_DENIED', 406);
		}
	}

	/** {@inheritdoc} */
	public function process(App\Request $request)
	{
		$recordId = $request->getInteger('record');
		$class = AccountPrivateRepository::class;

		$repository = (new Repository())->get($class);
		$accountEntity = $repository->findById($recordId);
		$mailAccount = new \App\Mail\Account($accountEntity, $repository);
		$provider = $mailAccount->getOAuthProvider();
		$state = $provider->getState();
		$url = $provider->getAuthorizationUrl(['login_hint' => $mailAccount->getLogin(), 'prompt' => 'consent']);

		$hash = sha1($state);
		\App\Session::set("OAuth.State.{$hash}", [
			'state' => $state,
			'recordId' => $recordId,
			'redirectUri' => \App\Config::main('site_URL') . 'index.php?module=OSSMailScanner&parent=Settings&view=List',
			'repositoryClass' => $class,
		]);

		header('location: ' . $url);
		exit;
	}

	/** {@inheritdoc} */
	public function validateRequest(App\Request $request)
	{
		$request->validateReadAccess();
	}
}
