<?php

/**
 * Standard YetiForce inventory field object.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Model\Field;

use App\Report\Enums\FieldType;
use App\Report\Model\Field;

/** YetiForceInventoryField class */
final class YetiForceInventoryField implements Field
{
	public function __construct(
		private readonly \Vtiger_Basic_InventoryField $field,
	) {}

	/** {@inheritDoc} */
	public function getType(): ?FieldType
	{
		return FieldType::tryFrom($this->field->getFieldDataType());
	}

	/** {@inheritDoc} */
	public function getNativeModel(): object
	{
		return $this->field;
	}

	/** {@inheritDoc} */
	public function getUITypeModel(): object
	{
		return $this->getNativeModel();
	}
}
