<?php
/**
 * Common repository for db connected queries
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Leszek Koziatek <l.koziatek@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Repository\Field;

use App\Db\Query;
use App\Report\Repository\FieldRepository;
use Throwable;

/** YiiFieldRepository class */
final class YiiFieldRepository implements FieldRepository
{
	/** {@inheritDoc} */
	public function getFieldStraight(string $fieldName, string $moduleName): ?array
	{
		$field = (new Query())
			->select(['vf.fieldlabel as label', 'vt.name as moduleName'])
			->from('vtiger_field vf')
			->innerJoin('vtiger_tab vt', 'vt.tabid = vf.tabid')
			->where(['vf.fieldname' => $fieldName])
			->andWhere(['vt.name' => $moduleName])
			->one();

		return false !== $field ? $field : null;
	}

	/** {@inheritDoc} */
	public function getInventoryField(string $fieldName, string $moduleName): ?array
	{
		$moduleTable = (new Query())
			->select('tablename')
			->from('vtiger_entityname')
			->where(['modulename' => $moduleName])
			->one();

		if (false === $moduleTable) {
			return null;
		}

		try {
			$field = (new Query())
				->select('label')
				->from(sprintf('%s_invfield', $moduleTable['tablename']))
				->where(['columnname' => $fieldName])
				->one();
		} catch (Throwable $throwable) {
			return null;
		}

		return false === $field
			? null
			: [
				'label' => $field['label'],
				'moduleName' => $moduleName,
			];
	}
}
