<?php

/**
 * Sanitize filter.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author  Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Sanitizer;

use App\Condition;
use App\Report\Factory\FieldFactory;
use App\Report\Model\Query;

/** FilterSanitizer class */
final class FilterSanitizer
{
	public function __construct(
		private readonly FieldFactory $fieldFactory,
	) {}

	public function sanitize(Query $query, array $conditions = []): array
	{
		if (isset($conditions['rules'])) {
			foreach ($conditions['rules'] as &$condition) {
				if (isset($condition['condition'])) {
					$condition = $this->sanitize($query, $condition);
				} else {
					$operator = $condition['operator'];
					$value = $condition['value'] ?? '';
					if (!\in_array($operator, array_merge(Condition::OPERATORS_WITHOUT_VALUES, Condition::FIELD_COMPARISON_OPERATORS, array_keys(Condition::DATE_OPERATORS)))) {
						$field = $this->fieldFactory->create($query, $condition['field']);
						$value = $field->getUITypeModel()->getDbConditionBuilderValue($value, $operator);
					}
					$condition['value'] = $value;
				}
			}
		}
		return $conditions;
	}
}
