<?php

namespace App\TextParser;

/**
 * Table tax summary class.
 *
 * @package TextParser
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */
class TableTaxSummary extends Base
{
	/** @var string Class name */
	public $name = 'LBL_TABLE_TAX_SUMMARY';

	/** @var mixed Parser type */
	public $type = 'pdf';

	/**
	 * Process.
	 *
	 * @return string
	 */
	public function process()
	{
		if (!$this->textParser->recordModel || !$this->textParser->recordModel->getModule()->isInventory()) {
			return '';
		}

		$html = '';
		$inventory = \Vtiger_Inventory_Model::getInstance($this->textParser->moduleName);
		$fields = $inventory->getFieldsByBlocks();
		$currencySymbol = $inventory->getCurrency($this->textParser->recordModel)['currency_symbol'] ?? '';

		if (!empty($fields[0]) && $inventory->isField('tax')) {
			$taxSummary = $inventory->getField('tax')->getTaxSummary($this->textParser->recordModel);

			if (\in_array('showNames', $this->params)) {
				foreach (\Vtiger_Inventory_Model::getGlobalTaxes() as $gt) {
					$key = \App\Fields\Double::formatToDisplay($gt['value']) .'%';

					if (isset($taxSummary['groups'][$key])) {
						$taxSummary['groups'][$gt['name'] . ': ' . $key] = $taxSummary['groups'][$key];
						unset($taxSummary['groups'][$key]);
					}
				}
			}

			if ($inventory->isField('tax') && $inventory->isField('taxmode')) {
				$html .= '<table class="table-tax-summary" style="width:100%;vertical-align:top;border-collapse:collapse;border:1px solid #ddd;">
						<thead>
							<tr>
								<th colspan="2" style="font-weight:bold;padding:0px 4px;background-color:#ddd;">' . \App\Language::translate('LBL_TAX_SUMMARY', $this->textParser->moduleName) . '</th>
							</tr>
						</thead><tbody>';
				foreach ($taxSummary['groups'] as $key => $tax) {
					$html .= '<tr>
								<td class="name" style="text-align:left;padding:0px 4px;">' . $key . '</td>
								<td class="value" style="text-align:right;padding:0px 4px;">' . \CurrencyField::convertToUserFormatSymbol($tax, true, $currencySymbol) . ' </td>
							</tr>';
				}
				$html .= '<tr class="summary">
						<th class="name" style="text-align:left;font-weight:bold;padding:0px 4px;">' . (\in_array('hideSumName', $this->params) ? '' : \App\Language::translate('LBL_AMOUNT', $this->textParser->moduleName)) . '</th>
						<th class="value" style="text-align:right;font-weight:bold;padding:0px 4px;">' . \CurrencyField::convertToUserFormatSymbol($taxSummary['total'], true, $currencySymbol) . ' </th>
					</tr>
				</tbody>
			</table>';
			}
		}

		return $html;
	}
}
