{*<!-- {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} -->*}
{strip}
	<!-- tpl-install-tpl-StepChooseModulePackages -->
	<div class="container px-2 px-sm-3">
		<main class="main-container">
			<div class="inner-container">
				{if $INSTALLATION_SUCCESS}
					<form class="" name="step{$STEP_NUMBER}" method="post" action="Install.php">
						<input type="hidden" name="mode" value="{$NEXT_STEP}">
						<div class="row">
							<div class="col-12 text-center">
								<h2>{App\Language::translate('LBL_BUSINESS_PROFILE', 'Install')}</h2>
							</div>
						</div>
						<hr>
						<div class="row">
							<p class="col-12 ml-3">
								{App\Language::translate('LBL_STEP_MODULE_PACKAGES_DESCRIPTION', 'Install')}
							</p>
						</div>
						<div class="row m-auto">
							{foreach $MODULE_PACKAGES as $PACKAGE}
								<div class="col-md-6 mb-3">
									<div class="modulePackage o-small-package pl-2 u-box-shadow-light my-auto u-cursor-pointer {if $PACKAGE['default_active']} checked{/if}">
										<div class="py-2 px-1">
											<div class="row mx-3 my-2">
												<div class="o-small-package__img">
													<span class="package-image u-fs-2x">
														<i class="fas {if $PACKAGE['icon']}{$PACKAGE['icon']|escape}{else}fa-puzzle-piece{/if}"></i>
													</span>
												</div>
												<div class="pl-3 pt-3">
													<h6 class="u-font-weight-600" title="{$PACKAGE['name']|escape}">
														{App\Language::translate($PACKAGE['label'], 'Settings:YetiForce')}
													</h6>
												</div>
												<div>
													<input type="checkbox" name="modulePackages[{$PACKAGE['id']}]" {if $PACKAGE['default_active']}checked="checked" {/if} value="{$PACKAGE['id']|escape}" />
												</div>
											</div>
											<div class="row mx-3 my-3">
												<p class="font-smaller u-font-weight-450">
													{App\Language::translate($PACKAGE['description'], 'Settings:YetiForce')}
												</p>
											</div>
										</div>
									</div>
								</div>
							{/foreach}
						</div>

						<div class="offset2">
							<div class="form-button-nav fixed-bottom button-container p-1 bg-light">
								<div class="text-center w-100">
									<button type="submit" class="btn btn-lg c-btn-block-xs-down btn-primary">
										{App\Language::translate('LBL_NEXT', 'Install')}
										<span class="fas fa-lg fa-arrow-circle-right ml-2"></span>
									</button>
								</div>
							</div>
						</div>
					</form>
				{else}
					<div class="container u-white-space-n u-word-break">
						<div class="card mx-auto mt-5 u-w-fit shadow" role="alert">
							<div class="card-header d-flex color-red-a200 bg-color-red-50 justify-content-center flex-wrap">
								<h3 class="align-items-center card-title d-flex justify-content-center">{App\Language::translate('LBL_ERROR_INSTALL', 'Install')}</h3>
							</div>
							<div class="card-body text-success">
								<pre>{App\Log::getlastLogs(['error'])}</pre>
							</div>
						</div>
					</div>
					<div class="form-button-nav fixed-bottom button-container p-1 bg-light">
						<div class="text-center w-100">
							<a class="btn btn-lg c-btn-block-xs-down btn-outline-primary mr-sm-1 mb-1 mb-sm-0" href="Install.php"
								role="button">
								<span class="fas fa-lg fa-arrow-circle-left mr-2"></span>
								{App\Language::translate('LBL_BACK', 'Install')}
							</a>
						</div>
					</div>
				{/if}
			</div>
		</main>
	</div>

	<script type="text/javascript">
		$('#progressIndicator').remove();
	</script>
	<!-- /tpl-install-tpl-StepChooseModulePackages -->
{/strip}
