<?php
/**
 * Bind an existing e-mail file.
 *
 * @package   App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

use App\Db;
use App\Mail\Account;
use App\Mail\Account\Repository\AccountPrivateRepository;
use App\QueryGenerator;

/**
 * Bind an existing e-mail class.
 */
class OSSMailScanner_Bind_Cron extends \App\CronHandler
{
	/** {@inheritdoc} */
	public function process()
	{
		$dbCommand = Db::getInstance()->createCommand();
		$queryGenerator = (new QueryGenerator('OSSMailView'))->setFields(['id', 'rc_user'])->addCondition('verify', 1, 'e');
		$dataReader = $queryGenerator->createQuery()->createCommand()->query();
		while ($row = $dataReader->read()) {
			$accountId = $row['rc_user'];
			$crmMailId = $row['id'];
			$repository = new AccountPrivateRepository();
			$entity = $repository->findById($accountId);
			if ($entity && ($mailAccount = new Account($entity, $repository))->isActive() && \in_array('BindMail', $mailAccount->getActions())) {
				$message = \App\Mail\Message\Imap::getInstanceById($crmMailId);
				(new \App\Mail\Scanner())->getAction('BindMail')->setAccount($mailAccount)->setMessage($message)->process();
			}
			$dbCommand->update('vtiger_ossmailview', ['verify' => 0], ['ossmailviewid' => $crmMailId])->execute();
		}
	}
}
