<?php
/**
 * Cron for mail scanner.
 *
 * @package   Cron
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

use App\Language;
use App\Log;
use App\Mail;
use App\Mail\Account;
use App\Mail\Account\Entity\Enum\Status;
use App\Mail\Account\Repository\AccountPrivateRepository;
use App\Mail\Scanner;

/**
 * OSSMailScanner scann cron class.
 */
class OSSMailScanner_Scann_Cron extends \App\CronHandler
{
	/** {@inheritdoc} */
	public function process()
	{
		$scanner = new Scanner();
		if (!$scanner->isReady()) {
			Log::warning(Language::translate('ERROR_ACTIVE_CRON', 'OSSMailScanner'));
			return;
		}
		$allDone = true;
		$limit = (int) Mail::getConfig('scanner', 'limit', 100);
		$scanner->setLimit($limit);

		$pauser = \App\Pauser::getInstance('MailAccountScanner');
		$lastId = (int) $pauser->getValue();

		$repository = new AccountPrivateRepository();
		foreach ($repository->getAllByStatus(Status::STATUS_ACTIVE, $lastId) as $entity) {
			$pauser->setValue((string) $entity->getId());

			$mailAccount = new Account($entity, $repository);
			$scanner->setAccount($mailAccount);
			$scanner->run(fn () => $this->checkTimeout());

			if ($this->checkTimeout() || $scanner->isLimitReached()) {
				$allDone = false;
				break;
			}
		}
		if ($allDone) {
			$pauser->destroy();
		}
	}
}
