<?php
/**
 * Main ReportTemplate module file
 *
 * @package   ReportTemplate
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Klaudia Łozowska <k.lozowska@yetiforce.com>
 */
declare(strict_types=1);

/* +**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 * ********************************************************************************** */

include_once 'modules/Vtiger/CRMEntity.php';

/** ReportTemplate class */
final class ReportTemplate extends Vtiger_CRMEntity
{
	/** Default fields on the list */
	public $list_fields_name = [
		'LBL_NAME' => 'name',
		'LBL_DESCRIPTION' => 'description',
		'Assigned To' => 'assigned_user_id',
	];

	/** For Popup listview and UI type support  */
	public $search_fields = [
		'LBL_NAME' => ['report_template', 'name'],
		'Assigned To' => ['vtiger_crmentity', 'assigned_user_id'],
	];

	public $search_fields_name = [];

	/** For Popup window record selection */
	public $popup_fields = ['name'];

	/** For Alphabetical search */
	public $def_basicsearch_col = 'name';

	/** @var string Column value to use on detail view record text display */
	public $def_detailview_recname = 'name';

	/**
	 * Used when enabling/disabling the mandatory fields for the module.
	 * Refers to vtiger_field.fieldname values.
	 * */
	public $mandatory_fields = ['name', 'assigned_user_id'];

	public $default_order_by = '';

	public $default_sort_order = 'ASC';

	/**
	 * Invoked when special actions are performed on the module.
	 *
	 * @param string $moduleName Module name
	 * @param string $eventType Event Type
	 */
	public function moduleHandler($moduleName, $eventType)
	{
		if ('module.postinstall' === $eventType) {
		} elseif ('module.disabled' === $eventType) {
		} elseif ('module.preuninstall' === $eventType) {
		} elseif ('module.preupdate' === $eventType) {
		} elseif ('module.postupdate' === $eventType) {
		}
	}
}
