<?php
/**
 * Base report field file.
 *
 * @package   Modules
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Adrian Kon <a.kon@yetiforce.com>
 */

 /**
  * Base report field class
  */
abstract class  ReportTemplate_BaseReportField_Model
{
	/** Aggregate field types */
	const AGGREGATE_FIELD_TYPES = ['currency', 'multiCurrency', 'currencyInventory', 'percentage', 'double', 'integer', 'GrossPrice', 'Tax', 'NetPrice', 'Discount', 'TotalPrice', 'UnitPrice', 'Quantity'];

	/** Aggregate functions */
	const AGGREGATE_FUNCTIONS = [
		'sum' => [
			'label' => 'LBL_SUM',
			'sign' => '+'
		],
		'diff' => [
			'label' => 'LBL_DIFF',
			'sign' => '-'
		],
		'quo' => [
			'label' => 'LBL_QUO',
			'sign' => '/'
		],
		'prod' => [
			'label' => 'LBL_PROD',
			'sign' => '*'
		]
	];

	/** Create report field */
	protected function createReportField(Vtiger_Field_Model $fieldModel): ReportTemplate_FieldReport_Model
	{
		$reportField = ReportTemplate_FieldReport_Model::from($fieldModel);
		$reportField->setExpressionField($fieldModel->getName());
		return $reportField;
	}

	/** Get aggregate function base on field type  */
	protected function getAggregations(string $fieldType): array
	{
		return match ($fieldType) {
			'currency', 'currencyInventory','percentage', 'double', 'integer', 'GrossPrice', 'Tax', 'NetPrice', 'Discount', 'TotalPrice', 'UnitPrice' , 'Quantity' => ['avg', 'sum', 'max', 'min'],
			'datetime', 'date' => ['max', 'min', 'year', 'month'],
			'entityidfield' => ['count', 'max', 'min'],
			default => [],
		};
	}

	/** Get base module field */
	protected function getBaseIdModuleField(string $moduleName): ReportTemplate_FieldReport_Model
	{
		$moduleReferenceInfo = App\Module::getEntityReferencesInfo($moduleName);
		$fieldParams = [
			'name' => 'id',
			'label' => App\Language::translate("SINGLE_{$moduleName}", $moduleName) . ' ' . App\Language::translate('LBL_RECORD_ID', 'ReportTemplate'),
			'uitype' => 7,
			'maximumlength' => '2147483647',
			'purifyType' => \App\Purifier::INTEGER,
			'table' => $moduleReferenceInfo['tablename']
		];
		$entityFieldModel = \Vtiger_Field_Model::init($moduleName, $fieldParams);
		return $this->createReportField($entityFieldModel);
	}

	/** Set field at begging of array */
	protected function unshiftField(array $moduleFields, ReportTemplate_FieldReport_Model $reportField): array
	{
		$blockNames = array_keys($moduleFields);
		$firstBlockName = reset($blockNames);
		array_unshift($moduleFields[$firstBlockName], $reportField);
		return $moduleFields;
	}

	/** Get translated module name */
	protected function getTranslatedModuleName(string $moduleName): string
	{
		return App\Language::translate($moduleName, $moduleName);
	}

	/** Get translated block name */
	protected function getTranslatedBlockName(string $moduleName, $blockName): string
	{
		return App\Language::translate($blockName, $moduleName);
	}

}
