<?php
/**
 * UserAuth AJAX save file.
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Antoni Kiszka <a.kiszka@yetiforce.com>
 */

/**
 * UserAuth AJAX save class.
 */
class Settings_UserAuth_SaveAjax_Action extends Settings_Vtiger_Save_Action
{
	/** {@inheritdoc} */
	public function checkPermission(App\Request $request)
	{
		parent::checkPermission($request);
		if ($request->isEmpty('providertype', true) || !\App\UserAuth::getProviderByName($request->getByType('providertype', \App\Purifier::ALNUM)) || (!$request->isEmpty('record') && !Settings_UserAuth_Record_Model::getInstanceById($request->getInteger('record'))->has('id'))) {
			throw new \App\Exceptions\NoPermittedForAdmin('LBL_PERMISSION_DENIED');
		}
	}

	/** {@inheritdoc} */
	public function process(App\Request $request)
	{
		$recordId = $request->isEmpty('record') ? null : $request->getInteger('record');
		if ($recordId) {
			$recordModel = Settings_UserAuth_Record_Model::getInstanceById($recordId);
		} else {
			$recordModel = Settings_UserAuth_Record_Model::getCleanInstance($request->getByType('providertype', \App\Purifier::ALNUM));
		}
		$result = $recordModel->setDataFromRequest($request);

		$response = new Vtiger_Response();
		try {
			$result = $recordModel->save();
			$prev = $recordModel->anonymize($recordModel->getPreviousValue());
			$post = $recordId ? array_intersect_key($recordModel->anonymize($recordModel->getData()), $prev) : $recordModel->anonymize($recordModel->getData());
			\Settings_Vtiger_Tracker_Model::addDetail($prev, $post);
			$response->setResult([$result]);
		} catch (Exception $e) {
			$response->setError($e->getMessage());
		}
		$response->emit();
	}
}
