<?php
/* +**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.1
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 * ********************************************************************************** */

class Settings_Workflows_List_View extends Settings_Vtiger_List_View
{
	public function initializeListViewContents(App\Request $request, App\Viewer $viewer)
	{
		$qualifiedModuleName = $request->getModule(false);
		if (!$this->listViewModel) {
			$this->listViewModel = Settings_Vtiger_ListView_Model::getInstance($qualifiedModuleName);
		}

		if (!$request->isEmpty('executionCondition')) {
			$executionCondition = $request->getInteger('executionCondition');
			$this->listViewModel->set('executionCondition', $executionCondition);
		}
		parent::initializeListViewContents($request, $viewer);
	}

	public function preProcess(App\Request $request, $display = true)
	{
		$viewer = $this->getViewer($request);
		$viewer->assign('SUPPORTED_MODULE_MODELS', Settings_Workflows_Module_Model::getSupportedModules());
		$viewer->assign('TRIGGER_TYPES', Settings_Workflows_Module_Model::TRIGGER_TYPES);
		$viewer->assign('CRON_RECORD_MODEL', Settings_CronTasks_Record_Model::getInstanceByName('LBL_WORKFLOW'));
		if (!$request->isEmpty('executionCondition')) {
			$executionCondition = $request->getInteger('executionCondition');
			$viewer->assign('EXECUTION_CONDITION', $executionCondition);
		}
		parent::preProcess($request, $display);
	}
}
