<?php
/**
 * Integration Comarch cron file.
 *
 * @package   Cron
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

/**
 * Integration Comarch cron class.
 */
class Vtiger_Comarch_Cron extends \App\CronHandler
{
	/** @var string[] List of main synchronizers for data exchange in Comarch integration */
	const SYNCHRONIZERS = [
		'sync_accounts' => 'Accounts',
		'sync_products' => 'Products',
		'sync_invoices' => 'Invoices',
		'sync_cor_invoices' => 'CorrectionInvoices',
		'sync_payments' => 'Payments',
	];

	/** {@inheritdoc} */
	public function process()
	{
		$bathCallback = fn (): bool => $this->checkTimeout() ? false : true;
		foreach (App\Integrations\Comarch\Config::getAllServers() as $serverId => $config) {
			$this->updateLastActionTime();
			$connector = (new App\Integrations\Comarch($serverId, $bathCallback));
			if ($message = $connector->testConnection()) {
				$this->addErrorLog($message);
				continue;
			}
			if (
				$connector->config->get('sync_cor_invoices')
				|| $connector->config->get('sync_invoices')
				|| $connector->config->get('sync_payments')
			) {
				$connector->getSync('Taxes')->process();
			}
			foreach (self::SYNCHRONIZERS as $key => $value) {
				if ($connector->config->get($key)) {
					$connector->getSync($value)->process();
				}
				if ($this->checkTimeout()) {
					return;
				}
			}
		}
	}
}
