'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";window.MailIntegration_Compose={/**
	 * AppConnector wrapper
	 *
	 * @param   {object}  request
	 *
	 * @return  {object}           AppConnector object with done method
	 */connector:function connector(request){var _this=this;return AppConnector.request(request).fail(function(){_this.showResponseMessage(!1);})},/**
	 * Show response message
	 *
	 * @param   {boolean}  success
	 * @param   {string}  message
	 */showResponseMessage:function showResponseMessage(success){var message=1<arguments.length&&arguments[1]!==void 0?arguments[1]:"";success?Office.context.mailbox.item.notificationMessages.replaceAsync("information",{type:"informationalMessage",message:message,icon:"iconid",persistent:!1}):Office.context.mailbox.item.notificationMessages.replaceAsync("error",{type:"errorMessage",message:app.vtranslate("JS_ERROR")+" "+message});},/**
	 * Registered autocomplete template
	 *
	 * @return  {object}  overwrite ui-autocomplete list item template
	 */registerAutocompleteTemplate:function registerAutocompleteTemplate(){$.widget("ui.autocomplete",$.ui.autocomplete,{_renderItem:function _renderItem(ul,item){return $(function listItemTemplate(user){return "<li class=\"c-search-item js-search-item\">\n\t\t\t\t\t<div class=\"\">\n\t\t\t\t\t\t\t\t<div class=\"row\">\n\t\t\t\t\t\t\t\t\t<div class=\"col-9 pr-0\">\n\t\t\t\t\t\t\t\t\t\t<div class=\"u-fs-14px\">".concat(user.name,"</div>\n\t\t\t\t\t\t\t\t\t\t<div class=\"c-search-item__mail small\">").concat(user.mail,"</div>\n\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t\t<div class=\"col-3 pr-0 text-right\">\n\t\t\t\t\t\t\t\t\t\t<button class=\"c-search-item__btn btn btn-xs btn-outline-primary\" data-copy-target=\"cc\">").concat(app.vtranslate("JS_CC"),"</button>\n\t\t\t\t\t\t\t\t\t\t<button class=\"c-search-item__btn btn btn-xs btn-outline-primary\" data-copy-target=\"bcc\">").concat(app.vtranslate("JS_BCC"),"</button>\n\t\t\t\t\t\t\t\t\t</div>\n\t\t\t\t\t\t\t\t</div></div>\n\t\t\t\t\t\t\t</li>")}(item)).appendTo(ul)}});},/**
	 * Register autocomplete
	 *
	 * @return  {jQuery}  autocomplete instance
	 */registerAutocomplete:function registerAutocomplete(){return this.container.find(".js-search-input").autocomplete({delay:"600",minLength:"3",classes:{"ui-autocomplete":"mobile"},source:function source(request,response){window.MailIntegration_Compose.findEmail(request,response);},select:function select(e,ui){var toElement="to";e.target.dataset.copyTarget?toElement=e.target.dataset.copyTarget:e.originalEvent.target.dataset.copyTarget?toElement=e.originalEvent.target.dataset.copyTarget:e.originalEvent.originalEvent.target.dataset.copyTarget&&(toElement=e.originalEvent.originalEvent.target.dataset.copyTarget),window.MailIntegration_Compose.copyRecipient(toElement,[{displayName:ui.item.name,emailAddress:ui.item.mail}]);}})},/**
	 * Find mail action for autocomplete source
	 *
	 * @param   {object}  request   autocomplete param
	 * @param   {fuction}  callBack  autocomplete callBack
	 */findEmail:function findEmail(request,callBack){this.connector({module:"MailIntegration",action:"Mail",mode:"findEmail",search:request.term}).done(function(responseData){var data=responseData.result.map(function(user){var userData=user.split(" <"),name=userData[0],mail=userData[1].slice(0,-1);return {name:name,mail:mail}});callBack(data);});},/**
	 * Copy recipient to outlook field
	 *
	 * @param   {string}  recipientsField  to, cc, bcc
	 * @param   {object}  newRecipient
	 */copyRecipient:function copyRecipient(recipientsField,newRecipient){Office.context.mailbox.item[recipientsField].addAsync(newRecipient,function(result){result.error&&Office.context.mailbox.item.notificationMessages.replaceAsync("error",{type:"errorMessage",message:app.vtranslate("JS_ERROR")+" "+result.error});});},registerEvents:function registerEvents(){$(".js-exception-error").length||(this.container=$("#page"),this.registerAutocompleteTemplate(),this.registerAutocomplete());}},"undefined"==typeof Office?app.showNotify({title:app.vtranslate("JS_ERROR"),type:"error"}):function(){Office.onReady(function(info){info.host===Office.HostType.Outlook&&window.MailIntegration_Compose.registerEvents();});}($);
//# sourceMappingURL=outlookMessageCompose.min.js.map
