/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */
'use strict';

Settings_Vtiger_Edit_Js(
	'Settings_MailSmtp_Edit_Js',
	{},
	{
		registerDependency() {
			let dependency = JSON.parse(this.container.find('.js-smtp-dependency').val());
			for (let field in dependency) {
				let fieldEl = this.container.find(`[name="${field}"]`);
				let conditions = dependency[field]['condition'];
				let hide = false;
				for (let conField in conditions) {
					let conFieldEl = this.container.find(`[data-fieldinfo][name="${conField}"]`);
					let conFieldElVal =
						conFieldEl.attr('type') === 'checkbox' ? Number(conFieldEl.is(':checked')) : conFieldEl.val();
					let { value, operator } = conditions[conField];
					if ((operator === 'e' && value == conFieldElVal) || (operator === 'n' && value != conFieldElVal)) {
						hide = true;
						break;
					}
				}
				if (hide) {
					fieldEl.closest('.js-field-container').addClass('d-none');
				} else {
					fieldEl.closest('.js-field-container').removeClass('d-none');
				}
			}
		},
		changeMailerType: function () {
			this.container.find('select').on('change', (e) => {
				this.registerDependency();
			});
			this.container.find('input[type="checkbox"]').on('click', (e) => {
				this.registerDependency();
			});
		},
		/**
		 * PreSave validation
		 */
		preSaveValidation: function () {
			const aDeferred = $.Deferred();
			let formData = new FormData(this.container[0]);
			formData.append('mode', 'preSaveValidation');
			AppConnector.request({
				async: false,
				url: 'index.php',
				type: 'POST',
				data: formData,
				processData: false,
				contentType: false
			})
				.done((data) => {
					let response = data.result;
					let errors = 0;
					for (let i in response) {
						if (response[i].result !== true) {
							++errors;
							app.showNotify({
								text: response[i].message ? response[i].message : app.vtranslate('JS_ERROR'),
								type: 'error'
							});
							if (response[i].hoverField != undefined) {
								this.container.find('[name="' + response[i].hoverField + '"]').focus();
							}
						}
					}
					aDeferred.resolve(data.result.length <= 0 || errors <= 0);
				})
				.fail((textStatus, errorThrown) => {
					app.showNotify({ text: app.vtranslate('JS_ERROR'), type: 'error' });
					app.errorLog(textStatus, errorThrown);
					aDeferred.resolve(false);
				});

			return aDeferred.promise();
		},

		/**
		 * Register submit event
		 */
		registerSubmitEvent() {
			this.container.off('submit').on('submit', (e) => {
				e.preventDefault();
				this.container.find('.js-toggle-panel').find('.js-block-content').removeClass('d-none');
				if ($(e.currentTarget).validationEngine('validate')) {
					let progressLoader = $.progressIndicator({
						message: app.vtranslate('JS_SAVE_LOADER_INFO'),
						position: 'html',
						blockInfo: {
							enabled: true
						}
					});
					this.preSaveValidation().done((response) => {
						if (response === true) {
							let formData = this.container.serializeFormData();
							app
								.saveAjax('save', [], formData)
								.done(function (data) {
									if (data.result && data.result.success) {
										app.showNotify({ text: app.vtranslate('JS_SAVE_SUCCESS'), type: 'success' });
										window.location.href = data.result.url;
									} else {
										progressLoader.progressIndicator({ mode: 'hide' });
										app.showNotify({ text: app.vtranslate('JS_ERROR'), type: 'error' });
									}
								})
								.fail(function () {
									progressLoader.progressIndicator({ mode: 'hide' });
									app.showNotify({ text: app.vtranslate('JS_ERROR'), type: 'error' });
								});
						} else {
							progressLoader.progressIndicator({ mode: 'hide' });
						}
					});
				}
				e.stopPropagation();
				return false;
			});
		},

		registerRunTest: function () {
			this.container.find('.js-mailsmtp-run').on('click', (e) => {
				let form = $(e.currentTarget).closest('form');
				this.container.find('.js-toggle-panel').find('.js-block-content').removeClass('d-none');
				if (form.validationEngine('validate')) {
					let progressLoader = $.progressIndicator({
						position: 'html',
						blockInfo: { enabled: true }
					});
					let formData = this.container.serializeFormData();
					formData['action'] = 'RunTest';
					app
						.saveAjax(null, [], formData)
						.done(function (data) {
							let response = data.result;
							if (data.success && response && response.result) {
								let message = response.message;
								app.showNotify({
									text: message ?? app.vtranslate('JS_SAVE_SUCCESS'),
									type: response.type ?? 'success'
								});
							} else {
								let message = response.message ? response.message : app.vtranslate('JS_ERROR');
								app.showNotify({ textTrusted: false, text: message, type: response.type ?? 'error' });
							}
						})
						.fail(function () {
							app.showNotify({ textTrusted: false, text: app.vtranslate('JS_ERROR'), type: 'error' });
						})
						.always(() => {
							progressLoader.progressIndicator({ mode: 'hide' });
						});
				}
			});
		},

		registerBasicEvents: function () {
			this.referenceModulePopupRegisterEvent(this.container);
			this.registerAutoCompleteFields(this.container);
			this.registerClearReferenceSelectionEvent(this.container);
			this.container.validationEngine(app.validationEngineOptionsForRecord);
			this.registerSubmitEvent();
			this.registerRunTest();
			app.registerBlockToggleEvent(this.container);
			App.Fields.Password.register(this.container);
			App.Fields.Text.registerCopyClipboard(this.container);
		},

		registerEvents: function () {
			this.container = this.getForm();
			this.changeMailerType();
			this.registerBasicEvents(this.container);
		}
	}
);
