'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";jQuery.Class("Settings_Password_Encryption_Js",{},{/**
		 * Container
		 */container:null,/**
		 * Set container
		 * @param {Object} element
		 */setContainer:function setContainer(element){this.container=element;},/**
		 * Get Container
		 * @returns {Object}
		 */getContainer:function getContainer(){return this.container},/**
		 * Get nav tab
		 * @returns {Object}
		 */getActiveTabNav:function getActiveTabNav(){return this.getContainer().find(".js-nav-container a.active")},/**
		 * Get tab (Form)
		 * @returns {Object}
		 */getTabForm:function getTabForm(){return this.getContainer().find(".tab-pane.active form")},/**
		 * Register change tab
		 */registerChangeTab:function registerChangeTab(){var _this=this,container=this.getContainer();this.passwordAlert(container),container.find(".js-nav-container a").on("click",function(e){_this.loadTab(e.currentTarget.dataset.url);});},/**
		 * Load content from URL
		 * @param {string} url
		 */loadTab:function loadTab(url){var _this2=this,tabContainer=this.getContainer().find(".js-tab-container"),progressIndicatorElement=$.progressIndicator({blockInfo:{elementToBlock:tabContainer,enabled:!0}});AppConnector.request(url).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),tabContainer.html(data),_this2.registerBasicEvents(tabContainer),App.Fields.Picklist.showSelect2ElementView(tabContainer.find("select"));}).fail(function(textStatus,errorThrown){app.errorLog(textStatus,errorThrown);});},/**
		 * Register events for change method encryption
		 */registerChangeMethodName:function registerChangeMethodName(){var _this3=this,container=this.getTabForm();container.length&&this.passwordAlert(container),container.find("[name=\"methods\"]").on("change",function(e){_this3.passwordAlert($(e.currentTarget).closest("form"));});},/**
		 * Register events for change method encryption
		 */registerChangeModule:function registerChangeModule(){var _this4=this;this.getTabForm().find("[name=\"target\"]").on("change",function(e){var url=_this4.getActiveTabNav().data("url")+"&target="+e.currentTarget.value;_this4.loadTab(url);});},/**
		 * Password alerts
		 * @param {jQuery} container
		 */passwordAlert:function passwordAlert(container){var methodElement=container.find("[name=\"methods\"]"),mapLengthVector=JSON.parse($("[name=\"lengthVectors\"]").val()),length=mapLengthVector[methodElement.val()],validator="",passwordElement=container.find("#password"),vectorElement=container.find("#vector"),passwordInfoAlert=container.find(".js-password-alert");length==null?(passwordInfoAlert.addClass("d-none"),vectorElement.attr("disabled","disabled"),passwordElement.attr("disabled","disabled")):0===length?(passwordInfoAlert.addClass("d-none"),vectorElement.val(""),vectorElement.attr("disabled","disabled")):(passwordInfoAlert.removeClass("d-none"),passwordInfoAlert.find(".js-password-length").text(length),vectorElement.removeAttr("disabled"),passwordElement.removeAttr("disabled"),validator="validate[required,maxSize["+length+"],minSize["+length+"]]"),vectorElement.attr("data-validation-engine",validator);},/**
		 * Register events for form
		 */registerForm:function registerForm(){var _this5=this,form=this.getTabForm();form.on("submit",function(event){if(event.preventDefault(),form.validationEngine(app.validationEngineOptions),form.validationEngine("validate")){var save=function(){var progressElement=$.progressIndicator({blockInfo:{enabled:!0}});AppConnector.request(form.serializeFormData()).done(function(response){progressElement.progressIndicator({mode:"hide"}),app.showNotify({text:response.result,type:"info",hide:!1}),_this5.getActiveTabNav().trigger("click");});},progressIndicatorElement=$.progressIndicator({blockInfo:{enabled:!0}}),formData=form.serializeFormData();formData.mode="checkEncryptionStatus",AppConnector.request(formData).done(function(response){progressIndicatorElement.progressIndicator({mode:"hide"}),response.result.message?app.showConfirmModal({text:response.result.message+"<div>".concat(app.vtranslate("JS_CHANGE_CONFIRMATION"),"</div>"),confirmedCallback:function confirmedCallback(){save();}}):response.result.result&&save();});}});},/**
		 * Register events to preview password
		 */registerPreviewPassword:function registerPreviewPassword(){var container=this.getTabForm(),button=container.find(".previewPassword");button.on("mousedown",function(){$("#"+$(this).data("id")).attr("type","text");}),button.on("mouseup",function(){$("#"+$(this).data("id")).attr("type","password");}),button.on("mouseout",function(){$("#"+$(this).data("id")).attr("type","password");});},/**
		 * Register basic events in view
		 */registerBasicEvents:function registerBasicEvents(){this.registerForm(),this.registerChangeMethodName(),this.registerChangeModule(),this.registerPreviewPassword();},/**
		 * Register all events in view
		 */registerEvents:function registerEvents(){this.setContainer($(".contentsDiv")),this.registerChangeTab(),this.registerBasicEvents();}});
//# sourceMappingURL=Encryption.min.js.map
