'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";$.Class("Settings_PublicHoliday_Js",{$progressiveIndicator:null,/**
		 * Shows progressive indicator
		 *
		 * @param none
		 * @return none
		 */showProgressive:function showProgressive(){Settings_PublicHoliday_Js.$progressiveIndicator=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});},/**
		 * Hides progressive indicator
		 *
		 * @param none
		 * @return none
		 */hideProgressive:function hideProgressive(){Settings_PublicHoliday_Js.$progressiveIndicator.progressIndicator({mode:"hide"});}},{$editModal:null,$duplicateModal:null,$itemsContainer:null,$activeDateFilter:null,/**
		 * Initialises the class
		 */init:function init(){var outer=$(".contents"),container=$("#moduleBlocks",outer);this.$editModal=$(".publicHolidayModal",outer),this.$duplicateModal=$(".publicHolidayModalMassDuplicate",outer),this.$itemsContainer=$("#itemsContainer",outer),$("form",this.$editModal).validationEngine($.extend({},app.validationEngineOptions,{binded:!1})),$("form",this.$duplicateModal).validationEngine($.extend({},app.validationEngineOptions,{binded:!1})),this.registerEvents(container);},/**
		 * Reloads holiday items into layout
		 *
		 * @param none
		 * @return none
		 */reloadItems:function reloadItems(){var thisInstance=this;AppConnector.request({parent:app.getParentModuleName(),module:app.getModuleName(),view:"Configuration",mode:"list",date:this.$activeDateFilter?this.$activeDateFilter.val():""}).done(function(response){response?thisInstance.$itemsContainer.html(response):Settings_Vtiger_Index_Js.showMessage({text:app.vtranslate("JS_ERROR"),type:"error"}),thisInstance.$itemsContainer.trigger("items.reloaded");}).fail(function(){app.showNotify({text:app.vtranslate("JS_ERROR"),type:"error"});});},/**
		 * Registers modal submit event (save, duplicate)
		 *
		 * @param container
		 * @return none
		 */registerModalSubmitEvent:function registerModalSubmitEvent(){var thisInstance=this;$("form",this.$editModal).add($("form",this.$duplicateModal)).on("submit",function(e){e.preventDefault();var $target=$(e.target),isValid=$target.validationEngine("validate");if(isValid){var params=$target.serializeFormData();Settings_PublicHoliday_Js.showProgressive(),AppConnector.request(params).done(function(response){Settings_PublicHoliday_Js.hideProgressive(),Settings_Vtiger_Index_Js.showMessage({text:response.result.message,type:response.result.success?"success":"error"}),thisInstance.reloadItems();}).fail(function(error){Settings_PublicHoliday_Js.hideProgressive(),app.showNotify({textTrusted:!1,text:error.toString(),type:"error"});}),app.hideModalWindow();}});},/**
		 * Registers event to add new public holiday
		 *
		 * @param container
		 * @return none
		 */registerAddHolidayEvent:function registerAddHolidayEvent(container){var thisInstance=this,$addPublicHoliday=$(".addPublicHoliday",container);$addPublicHoliday.click(function(){var $editModalClone=thisInstance.$editModal.clone(!0,!0);App.Fields.Picklist.showSelect2ElementView($("select",$editModalClone)),app.showModalWindow($editModalClone);});},/**
		 * Registers event to edit existing public holiday
		 *
		 * @param container
		 * @return none
		 */registerEditHolidayEvent:function registerEditHolidayEvent(){var thisInstance=this;this.$itemsContainer.on("click",".editHoliday",function(e){var $target=$(e.target),$editModalClone=thisInstance.$editModal.clone(!0,!0),$holidayDetails=$target.closest(".holidayElement").data();$("[name=holidayId]",$editModalClone).val($holidayDetails.holidayId),$("[name=holidayDate]",$editModalClone).val($holidayDetails.holidayDate),$("[name=holidayType]",$editModalClone).val($holidayDetails.holidayType),$("[name=holidayName]",$editModalClone).val($holidayDetails.holidayName),App.Fields.Picklist.showSelect2ElementView($("select",$editModalClone)),app.showModalWindow($editModalClone);});},/**
		 * Registers event to delete existing public holiday
		 *
		 * @param container
		 * @return none
		 */registerDeleteHolidayEvent:function registerDeleteHolidayEvent(){var thisInstance=this;this.$itemsContainer.on("click",".deleteHoliday",function(e){app.showConfirmModal({title:app.vtranslate("JS_DELETE_RECORD_CONFIRMATION"),confirmedCallback:function confirmedCallback(){var $target=$(e.target),$holidayDetails=$target.closest(".holidayElement").data();Settings_PublicHoliday_Js.showProgressive(),AppConnector.request({parent:app.getParentModuleName(),module:app.getModuleName(),action:"Holiday",mode:"delete",id:$holidayDetails.holidayId}).done(function(response){Settings_PublicHoliday_Js.hideProgressive(),Settings_Vtiger_Index_Js.showMessage({text:response.result.message,type:response.result.success?"success":"error"}),thisInstance.reloadItems();}).fail(function(error){Settings_PublicHoliday_Js.hideProgressive(),app.showNotify({textTrusted:!1,text:error.toString(),type:"error"});});}});});},/**
		 * Registers mass action checkboxes events
		 *
		 * @param none
		 * @return none
		 */registerChangeMassSelectionEvent:function registerChangeMassSelectionEvent(container){container.on("change",".selectall",function(e){var checked=$(e.target).is(":checked");$(".selectall",container).prop("checked",checked),$(".mass-selector",container).prop("checked",checked);}),container.on("change",".mass-selector",function(e){var $target=$(e.target);$target.is(":checked")?0>=$(".mass-selector:not(:checked)",container).length&&$(".selectall",container).prop("checked",!0):$(".selectall",container).prop("checked",!1);}),this.$itemsContainer.on("items.reloaded",function(){$(".selectall",container).prop("checked",!1);});},/**
		 * Registers mass actions event: duplicate and delete
		 *
		 * @param container
		 * @return none
		 */registerMassActionEvent:function registerMassActionEvent(container){var thisInstance=this;$(".masscopy",container).click(function(){var isChecked=$(".mass-selector",container).is(":checked");if(isChecked){var $duplicateModalClone=thisInstance.$duplicateModal.clone(!0,!0);App.Fields.Picklist.showSelect2ElementView($("select",$duplicateModalClone));var recordList=$(".mass-selector:checked",container).map(function(_,selector){return $(selector).data("id")}).toArray();$("[name=holidayIds]",$duplicateModalClone).val(JSON.stringify(recordList)),app.showModalWindow($duplicateModalClone);}else Settings_Vtiger_Index_Js.showMessage({text:app.vtranslate("JS_PLEASE_SELECT_ONE_RECORD"),type:"info"});}),$(".massdelete",container).click(function(){var isChecked=$(".mass-selector",container).is(":checked");isChecked?app.showConfirmModal({title:app.vtranslate("JS_DELETE_RECORD_CONFIRMATION"),confirmedCallback:function confirmedCallback(){var recordList=$(".mass-selector:checked",container).map(function(idx,selector){return $(selector).data("id")}).toArray();Settings_PublicHoliday_Js.showProgressive(),AppConnector.request({parent:app.getParentModuleName(),module:app.getModuleName(),action:"Holiday",mode:"massDelete",records:recordList}).done(function(response){Settings_PublicHoliday_Js.hideProgressive(),Settings_Vtiger_Index_Js.showMessage({text:response.result.message,type:response.result.success?"success":"error"}),thisInstance.reloadItems();}).fail(function(error){Settings_PublicHoliday_Js.hideProgressive(),app.showNotify({textTrusted:!1,text:error.toString(),type:"error"});});}}):Settings_Vtiger_Index_Js.showMessage({text:app.vtranslate("JS_PLEASE_SELECT_ONE_RECORD"),type:"info"});});},/**
		 * Registers date filter change event
		 *
		 * @param container
		 * @return none
		 */registerChangeDateFilterEvent:function registerChangeDateFilterEvent(container){var _this=this;$.each(container.find(".dateFilter"),function(idx,dateFilter){var $dateFilter=$(dateFilter),$form=$dateFilter.closest("form");App.Fields.Date.registerRange($dateFilter,{ranges:!1}),$form.validationEngine($.extend({},app.validationEngineOptions,{binded:!0})),$dateFilter.on("change",function(){var isValid=$form.validationEngine("validate");isValid&&(_this.$activeDateFilter=$dateFilter,_this.reloadItems());}),$form.on("click",".js-range-reset",function(){$dateFilter.val("").trigger("change");});});},/**
		 * Registers events for layout
		 *
		 * @param container
		 * @return none
		 */registerEvents:function registerEvents(container){this.registerModalSubmitEvent(container),this.registerAddHolidayEvent(container),this.registerEditHolidayEvent(container),this.registerDeleteHolidayEvent(container),this.registerChangeMassSelectionEvent(container),this.registerMassActionEvent(container),this.registerChangeDateFilterEvent(container);}}),$(document).ready(function(){new Settings_PublicHoliday_Js;});
//# sourceMappingURL=PublicHoliday.min.js.map
