/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */
'use strict';

/**
 * Transfer Ownership JS class for base modules.
 */
$.Class(
	'Base_TransferOwnership_JS',
	{},
	{
		/**
		 * Save transfer ownership for detail view.
		 */
		saveForDetail: function () {
			AppConnector.request({
				module: app.getModuleName(),
				action: 'TransferOwnership',
				record: app.getRecordId(),
				transferOwnerId: this.container.find('[name="transferOwnerId"]').val(),
				related_modules: this.container.find('#related_modules').val()
			}).done(function (data) {
				if (data.success) {
					app.showNotify({
						title: app.vtranslate('JS_MESSAGE'),
						text: app.vtranslate('JS_RECORDS_TRANSFERRED_SUCCESSFULLY'),
						type: 'info'
					});
					app.hideModalWindow();
					if (data.result.redirect) {
						window.location.href = data.result.redirect;
					} else {
						window.location.reload();
					}
				}
			});
		},

		/**
		 * Save transfer ownership for list view.
		 */
		saveForList: function () {
			const listInstance = Vtiger_List_Js.getInstance();
			let params = {
				module: app.getModuleName(),
				action: 'TransferOwnership',
				transferOwnerId: this.container.find('[name="transferOwnerId"]').val(),
				related_modules: this.container.find('#related_modules').val()
			};
			params = $.extend(params, listInstance.getSearchParams());
			delete params.view;
			const progressIndicatorElement = $.progressIndicator();
			AppConnector.request(params)
				.done((response) => {
					app.hideModalWindow();
					progressIndicatorElement.progressIndicator({ mode: 'hide' });
					listInstance.getListViewRecords();
					Vtiger_List_Js.clearList();
					if (response.result.success) {
						Vtiger_Helper_Js.showMessage({
							title: app.vtranslate('JS_MESSAGE'),
							text: app.vtranslate('JS_RECORDS_TRANSFERRED_SUCCESSFULLY'),
							type: 'info'
						});
					} else {
						Vtiger_Helper_Js.showMessage(response.result.notify);
					}
				})
				.fail(function () {
					progressIndicatorElement.progressIndicator({ mode: 'hide' });
				});
		},

		/**
		 * Save transfer ownership for relation list view.
		 */
		saveForRelationList: function () {
			const listInstance = this.baseWindow.Vtiger_RelatedList_Js.relatedListInstance;
			let validationResult = listInstance.checkListRecordSelected();
			if (validationResult != true) {
				let progressIndicatorElement = $.progressIndicator(),
					selectedIds = listInstance.readSelectedIds(true),
					excludedIds = listInstance.readExcludedIds(true),
					cvId = listInstance.getCurrentCvId(),
					postData = listInstance.getCompleteParams();
				delete postData.mode;
				delete postData.view;
				postData.action = 'TransferOwnership';
				postData.transferOwnerId = this.container.find('[name="transferOwnerId"]').val();
				postData.related_modules = this.container.find('#related_modules').val();
				postData.viewname = cvId;
				postData.selected_ids = selectedIds;
				postData.excluded_ids = excludedIds;
				AppConnector.request(postData)
					.done((response) => {
						app.hideModalWindow();
						progressIndicatorElement.progressIndicator({ mode: 'hide' });
						if (response.result.success) {
							Vtiger_Helper_Js.showMessage({
								title: app.vtranslate('JS_MESSAGE'),
								text: app.vtranslate('JS_RECORDS_TRANSFERRED_SUCCESSFULLY'),
								type: 'info'
							});
						} else {
							Vtiger_Helper_Js.showMessage(response.result.notify);
						}
						if (response.result.redirect) {
							this.baseWindow.window.location.href = response.result.redirect;
						} else {
							this.baseWindow.Vtiger_Detail_Js.reloadRelatedList();
						}
					})
					.fail(function () {
						progressIndicatorElement.progressIndicator({ mode: 'hide' });
					});
			} else {
				self.noRecordSelectedAlert();
			}
		},

		/**
		 * Register events for transfer ownership modal.
		 * @param {jQuery} container
		 */
		registerEvents(container) {
			const self = this;
			this.container = container;
			let params = { ...app.validationEngineOptions };
			params.onValidationComplete = function (form, valid) {
				if (valid) {
					switch (container.data('sourceView')) {
						case 'Detail':
							self.saveForDetail();
							break;
						case 'List':
							self.saveForList();
							break;
						case 'RelationList':
							self.saveForRelationList();
							break;
						default:
							break;
					}
				}
				return false;
			};
			this.container.find('form').validationEngine(params);
		}
	}
);
