<?php

/**
 * Virtual query condition field file.
 *
 * @package UIType
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

namespace App\Conditions\QueryFields;

use App\Log;

/**
 * Virtual query condition field class.
 */
class VirtualField extends BaseField
{
	/** {@inheritdoc} */
	public function getColumnName(): string
	{
		if ($this->fullColumnName) {
			return $this->fullColumnName;
		}

		return $this->fullColumnName = $this->queryGenerator->resolveRelatedField($this->getRelatedFieldDetails());
	}

	/** {@inheritdoc} */
	public function getCondition(?string $operator = null)
	{
		$detail = $this->getRelatedFieldDetails();
		$detail['value'] = $this->getValue();
		$detail['operator'] = $operator ?? $this->getOperator();

		return $this->queryGenerator->getRelatedCondition($detail);
	}

	/** {@inheritdoc} */
	public function getOrderBy($order = false): array
	{
		$fieldDetail = $this->getRelatedFieldDetails();
		$field = $this->queryGenerator->addRelatedJoin($fieldDetail);
		if (!$field) {
			Log::error('Not found virtual field');
		}
		return $this->queryGenerator->getQueryRelatedField($fieldDetail, $field)->getOrderBy($order);
	}

	private function getRelatedFieldDetails(): array
	{
		[$baseField , $refModuleName, $refFieldName] = explode('::', $this->getField()->getParam('virtualField'));
		return [
			'relatedModule' => $refModuleName,
			'relatedField' => $refFieldName,
			'sourceField' => $baseField,
		];
	}
}
