<?php

/**
 * FieldProviderInterface class.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Leszek Koziatek <l.koziatek@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Provider;

/** FieldProviderInterface class */
interface FieldsProvider
{
	/**
	 * Get all fields headers in report.
	 *
	 * @param int $id
	 *
	 * @return array<string, string> - key is an alias of the column, value is a translated label
	 */
	public function provide(int $id): array;

	/**
	 * Raw data. Multi-level structure.
	 *
	 * @param string $moduleName
	 * @param array  $expressions
	 *
	 * @return array
	 */
	public function provideByData(string $moduleName, array $expressions): array;

	/**
	 * Get fields for grouping purpose.
	 *
	 * @param int $id
	 *
	 * @return array<string> - e.g. ['A','B'] Column indexes where merging files should be applied
	 */
	public function wrappedFields(int $id): array;
}
