<?php
/**
 * Repository class for field objects
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Leszek Koziatek <l.koziatek@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Repository;

/** FieldRepository interface */
interface FieldRepository
{
	/**
	 * Get field label and module from other module
	 *
	 * @return null|array{label: string, moduleName: string}
	 */
	public function getFieldStraight(string $fieldName, string $moduleName): ?array;

	/**
	 * Get field label and module from related inventory name
	 *
	 * @return null|array{label: string, moduleName: string}
	 */
	public function getInventoryField(string $fieldName, string $moduleName): ?array;
}
