<?php
/**
 * Settings mail SaveAjax action class.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 */

use App\Mail\Account\Repository\AutologinRepository;
use App\Purifier;

class Settings_Mail_Autologin_Action extends Settings_Vtiger_Save_Action
{
	/**
	 * Process.
	 *
	 * @param \App\Request $request
	 *
	 * @throws \ReflectionException
	 */
	public function process(App\Request $request)
	{
		$id = $request->getInteger('id');
		$user = $request->getArray('user', Purifier::INTEGER);

		$repository = new AutologinRepository();
		$repository->save($id, $user);

		$response = new Vtiger_Response();
		$response->setResult([
			'success' => true,
			'message' => App\Language::translate('LBL_SAVED_CHANGES', $request->getModule(false)),
		]);
		$response->emit();
	}
}
