<?php

/**
 * Service for build filter group used in Query Generator.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 * @author Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Builder;

use App\Report\Enums\ConditionType;
use App\Report\Model\FilterGroup;
use App\Report\Model\Query;

/** FilterGroupBuilder class */
final class FilterGroupBuilder
{
	public function __construct(
		private readonly FilterBuilder $filterBuilder,
	) {}

	/** Build Filter group */
	public function build(array $data, Query $query): FilterGroup
	{
		$id = $data['filter_group_id'] ?? (max($query->getFilterGroupIds() ?: [0]) + 1);

		return new FilterGroup(
			$id,
			$query,
			ConditionType::tryFrom($data['condition']),
			$query->getFilterGroup($data['filter_group_parent_id'] ?? null),
		);
	}
}
