<?php
/**
 * Available relations for reports
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Enums;

enum Relations: string
{
	case getDependentsList = 'getDependentsList';
	case getActivities = 'getActivities';
	case getAttachments = 'getAttachments';
	case getProducts = 'getProducts';
	case getCampaigns = 'getCampaigns';
	case getCampaignsRecords = 'getCampaignsRecords';
	case getProductPricebooks = 'getProductPricebooks';
	case getPricebookProducts = 'getPricebookProducts';
	case getPricebookServices = 'getPricebookServices';
	case getServicePricebooks = 'getServicePricebooks';
	case getLeads = 'getLeads';
	case getAccounts = 'getAccounts';
	case getRelatedList = 'getRelatedList';
	case getManyToMany = 'getManyToMany';
	case getRelatedMembers = 'getRelatedMembers';
}
