<?php
/**
 * Mapper prepares filter group for Query Generator usage
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Mapper\Filter;

use App\Report\Mapper\FilterMapper;
use App\Report\Model\FilterGroup;

/** QueryGeneratorFilterMapper class */
final class QueryGeneratorFilterMapper implements FilterMapper
{
	/** {@inheritDoc} */
	public function map(FilterGroup $filterGroup): array
	{
		$result = ['condition' => $filterGroup->getCondition()->value];

		foreach ($filterGroup->getChildren() as $child) {
			$result['rules'][] = $this->map($child);
		}

		foreach ($filterGroup->getFilters() as $filter) {
			$result['rules'][] = [
				'fieldname' => $filter->getFirstValue(),
				'operator' => $filter->getOperator()->value,
				'value' => $filter->getSecondValue(),
			];
		}

		return $result;
	}
}
