<?php

/**
 * Report template detail view model file.
 *
 * @package Model
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Adrian Kon <a.kon@yetiforce.com>
 */

use App\Privilege;

/**
 * Report template detail view model class.
 */
class ReportTemplate_DetailView_Model extends Vtiger_DetailView_Model
{
	/** {@inheritdoc} */
	public function getDetailViewLinks(array $linkParams): array
	{
		$linkModelList = parent::getDetailViewLinks($linkParams);
		$recordModel = $this->getRecord();
		if (Privilege::isPermitted('Documents', 'CreateView')) {
			$linkModelList['DETAIL_VIEW_ADDITIONAL'][] = Vtiger_Link_Model::getInstanceFromValues([
				'linktype' => 'DETAIL_VIEW_ADDITIONAL',
				'linklabel' => 'BTN_GENERATE_REPORT',
				'linkclass' => 'btn-sm btn-success',
				'linkurl' => \sprintf('javascript:ReportTemplate_Detail_Js.generateReport(%d)', $recordModel->getId()),
				'linkicon' => 'fas fa-download',
			]);
		}

		return $linkModelList;
	}
}
