<?php

/**
 * Fields formula modal view file.
 *
 * @package View
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Adrian Kon <a.kon@yetiforce.com>
 */

/**
 * Select fields formula for report modal view class.
 */
class ReportTemplate_FieldFormulaModal_View extends \App\Controller\Modal
{
	/** {@inheritdoc} */
	public $modalIcon = 'fa-solid fa-square-root-variable';

	/** {@inheritdoc} */
	public $showFooter = false;

	/** {@inheritdoc} */
	protected $pageTitle = 'LBL_CREATE_FORMULA';

	/** {@inheritdoc} */
	public function checkPermission(App\Request $request)
	{
		if (!\App\Privilege::isPermitted($request->getModule(), 'DetailView')) {
			throw new \App\Exceptions\NoPermittedToRecord('ERR_NO_PERMISSIONS_FOR_THE_RECORD', 406);
		}
	}

	/** {@inheritdoc} */
	public function process(App\Request $request): void
	{
		$moduleName = $request->getModule();
		$sourceModule = $request->getByType('sourceModule', App\Purifier::ALNUM);
		$relations = $request->getArray('relations', App\Purifier::ALNUM);

		$aggregateFields = new ReportTemplate_Aggregate_Field($sourceModule, $relations);
		$viewer = $this->getViewer($request);
		$viewer->assign('FUNCTION_TYPES', ReportTemplate_Aggregate_Field::AGGREGATE_FUNCTIONS);
		$viewer->assign('AGGREGATE_FIELDS', $aggregateFields->getFields());
		$viewer->view('Modals/FieldFormula.tpl', $moduleName);
	}
}
