'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";Settings_PDF_Edit_Js("Settings_PDF_Edit1_Js",{},{init:function init(){this.initialize();},/**
		 * Function to get the container which holds all the reports step1 elements
		 * @return jQuery object
		 */getContainer:function getContainer(){return this.step1Container},/**
		 * Function to set the reports step1 container
		 * @params : element - which represents the reports step1 container
		 * @return : current instance
		 */setContainer:function setContainer(element){return this.step1Container=element,this},/**
		 * Function  to intialize the reports step1
		 */initialize:function initialize(container){"undefined"==typeof container&&(container=jQuery("#pdf_step1")),container.is("#pdf_step1")?this.setContainer(container):this.setContainer(jQuery("#pdf_step1"));},/**
		 * Submit step 1
		 * @returns {Promise}
		 */submit:function submit(){var aDeferred=jQuery.Deferred(),form=this.getContainer(),progressIndicatorElement=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}}),formData=new FormData,saveData=form.serializeFormData();for(var key in formData.append("action","Save"),formData.append("step",1),formData.append("template_id",form.find("[name=\"record\"]").val()),saveData.async=!1,"undefined"==typeof saveData.metatags_status&&(saveData.metatags_status=0),saveData)formData.append(key,saveData[key]);var fileSelect=form.find("#watermark_image");if("undefined"!=typeof fileSelect[0].files[0]){var file=fileSelect[0].files[0];file.type.match("image.*")&&formData.append("watermark_image_file",file,file.name);}return AppConnector.request({method:"POST",data:formData,processData:!1,contentType:!1}).done(function(data){if(!0===data.success){Settings_Vtiger_Index_Js.showMessage({text:app.vtranslate("JS_PDF_SAVED_SUCCESSFULLY")});var pdfRecordElement=jQuery("[name=\"record\"]",form);""===pdfRecordElement.val()&&(pdfRecordElement.val(data.result.id),saveData.record=data.result.id),saveData.record=data.result.id,AppConnector.request(saveData).done(function(data){form.hide(),progressIndicatorElement.progressIndicator({mode:"hide"}),aDeferred.resolve(data);}).fail(function(error,err){app.errorLog(error,err);});}}).fail(function(error,err){app.errorLog(error,err);}),aDeferred.promise()},registerCancelStepClickEvent:function registerCancelStepClickEvent(form){jQuery("button.cancelLink",form).on("click",function(){window.history.back();});},registerMarginCheckboxClickEvent:function registerMarginCheckboxClickEvent(container){container.find("#margin_chkbox").on("change",function(){var status=jQuery(this).is(":checked");status?container.find(".margin_inputs").addClass("d-none"):container.find(".margin_inputs").removeClass("d-none");});},/**
		 * Register module change event - load proper variable panel for specified module
		 * @param {jQuery} container
		 */registerModuleChangeEvent:function registerModuleChangeEvent(container){container.find("[name=\"module_name\"]").on("change",function(){var progressIndicator=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}});AppConnector.request({module:"PDF",parent:"Settings",view:"VariablePanel",record:container.find("[name=\"record\"]").val(),type:"pdf",selectedModule:$(this).val()}).done(function(response){container.find(".js-variable-panel").html(response),App.Tools.VariablesPanel.registerRefreshCompanyVariables(container),App.Fields.Text.registerCopyClipboard(container),progressIndicator.progressIndicator({mode:"hide"});}).fail(function(error,err){progressIndicator.progressIndicator({mode:"hide"}),app.errorLog(error,err);});});},registerWatermarkTypeChange:function registerWatermarkTypeChange(container){var watermarkType=container.find("#watermark_type");watermarkType.on("change",function(){container.find(".watertext").toggleClass("d-none"),container.find(".waterimage").toggleClass("d-none");});},registerDeleteUploadButton:function registerDeleteUploadButton(form){form.find("#deleteWM").on("click",function(e){e.preventDefault();var params={};params.data={parent:app.getParentModuleName(),module:app.getModuleName(),action:"Watermark",mode:"delete",id:form.find("[name=\"record\"]").val()},params.dataType="json",AppConnector.request(params).done(function(data){var response=data.result;response&&(form.find("#watermark").html(""),form.find("[name=\"watermark_image\"]").val(""),form.find("#deleteWM").addClass("d-none"));}).fail(function(data,err){app.errorLog(data,err);});});},/**
		 * Register events
		 */registerEvents:function registerEvents(){var container=this.getContainer();//After loading 1st step only, we will enable the Next button
container.find("[type=\"submit\"]").removeAttr("disabled");var opts=app.validationEngineOptions;// to prevent the page reload after the validation has completed
opts.onValidationComplete=function(form,valid){//returns the valid status
return valid},opts.promptPosition="bottomRight",container.validationEngine(opts),this.registerCancelStepClickEvent(container),this.registerMarginCheckboxClickEvent(container),this.registerModuleChangeEvent(container),this.registerWatermarkTypeChange(container),this.registerDeleteUploadButton(container),App.Tools.VariablesPanel.registerRefreshCompanyVariables(container),App.Fields.Text.registerCopyClipboard(container),App.Tools.VariablesPanel.refreshCompanyVariables(container);}});
//# sourceMappingURL=Edit1.min.js.map
