'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";$.Class("Base_RecordsList_JS",{},{/**
		 * Event for select row
		 */selectEvent:!1,/**
		 * List search instance
		 */listSearchInstance:!1,/**
		 * Module name
		 */moduleName:!1,/**
		 * Modal container
		 */container:!1,/**
		 * Set event for select row
		 * @param {function} cb
		 */setSelectEvent:function setSelectEvent(cb){this.selectEvent=cb;},/**
		 * Get params for record list
		 * @returns {{module: string, view: string, src_module: string, src_record: int, src_field: string, related_parent_module: string, related_parent_id: int|string, page: int, orderby: string, multi_select: boolean, totalCount: int|string, noOfEntries: int, onlyBody: boolean}}
		 */getParams:function getParams(){var params={module:this.moduleName,view:this.container.data("view"),src_module:this.container.find(".js-parent-module").val(),src_record:this.container.find(".js-source-record").val(),src_field:this.container.find(".js-source-field").val(),related_parent_module:this.container.find(".js-related-parent-module").val(),related_parent_id:this.container.find(".js-related-parent-id").val(),page:this.container.find(".js-page-number").val(),orderby:this.container.find("#orderBy").val(),multi_select:this.container.find(".js-multi-select").val(),totalCount:this.container.find(".js-total-count").val(),noOfEntries:this.container.find(".js-no-entries").val(),filterFields:JSON.parse(this.container.find(".js-filter-fields").val()),lockedFields:this.container.find(".js-locked-fields").val(),lockedEmptyFields:this.container.find(".js-empty-fields").val(),onlyBody:!0,cvId:this.getFilterSelectElement().val()||0,additionalData:this.container.find(".js-rl-additional_data").val()||null},searchValue=this.listSearchInstance.getAlphabetSearchValue();return params.search_params=this.listSearchInstance.getListSearchParams(!0),"undefined"!=typeof searchValue&&0<searchValue.length&&(params.search_key=this.listSearchInstance.getAlphabetSearchField(),params.search_value=searchValue,params.operator="s"),this.listSearchInstance.parseConditions(params),params.search_params=JSON.stringify(params.search_params),params},/**
		 * Load records list
		 * @param {object} params
		 * @returns {*}
		 */loadRecordList:function loadRecordList(params){var _this=this,body=this.container.find(".js-modal-body"),aDeferred=$.Deferred(),progressIndicatorElement=$.progressIndicator({blockInfo:{enabled:!0,elementToBlock:body}});return AppConnector.request($.extend(this.getParams(),params)).done(function(responseData){progressIndicatorElement.progressIndicator({mode:"hide"}),body.html(responseData),_this.registerBasicEvents(),aDeferred.resolve(responseData);}).fail(function(textStatus,errorThrown){aDeferred.reject(textStatus,errorThrown),progressIndicatorElement.progressIndicator({mode:"hide"}),app.showNotify({text:app.vtranslate("JS_NOT_ALLOWED_VALUE"),type:"error"});}),aDeferred.promise()},/*
		 * Register the click event for listView headers
		 */registerHeadersClickEvent:function registerHeadersClickEvent(){var _this2=this;YetiForce_ListSearch_Js.registerSearch(this.container,function(data){_this2.loadRecordList(data).done(function(){_this2.updatePagination();});});},/**
		 * Update record pagination
		 * @param {boolean} countNumberRecords
		 */updatePagination:function updatePagination(countNumberRecords){var _this3=this,params=this.getParams();params.mode="getPagination",countNumberRecords&&(params.showTotalCount=!0),AppConnector.request(params).done(function(responseData){_this3.container.find(".js-pagination-container").html(responseData);var totalCount=_this3.container.find(".js-pagination-list").data("totalCount");totalCount&&_this3.container.find(".js-total-count").val(totalCount),_this3.registerPaginationEvents();});},/**
		 * Register pagination events
		 */registerPaginationEvents:function registerPaginationEvents(){var self=this;this.container.find(".js-next-page").on("click",function(){if(!$(this).hasClass("disabled")&&self.container.find(".js-no-entries").val()==self.container.find(".js-page-limit").val()){var pageNumber=self.container.find(".js-page-number"),nextPageNumber=parseInt(parseFloat(pageNumber.val()))+1;pageNumber.val(nextPageNumber),self.loadRecordList().done(function(){self.updatePagination();});}}),this.container.find(".js-page--previous").on("click",function(){var pageNumber=self.container.find(".js-page-number");if(1<pageNumber.val()){var nextPageNumber=parseInt(parseFloat(pageNumber.val()))-1;pageNumber.val(nextPageNumber),self.loadRecordList().done(function(){self.updatePagination();});}}),this.container.find(".js-page--set").on("click",function(){$(this).hasClass("disabled")||(self.container.find(".js-page-number").val($(this).data("id")),self.loadRecordList().done(function(){self.updatePagination();}));}),this.container.find(".js-count-number-records").on("click",function(){app.hidePopover($(this)),Vtiger_Helper_Js.showMessage({title:app.vtranslate("JS_LBL_PERMISSION"),text:app.vtranslate("JS_GET_PAGINATION_INFO"),type:"info"}),self.updatePagination(!0);}),this.container.find(".js-page--jump-drop-down").on("click","li",function(e){e.stopImmediatePropagation();}).on("keypress",".js-page-jump",function(e){if(13==e.which){e.stopImmediatePropagation();var element=$(this),response=Vtiger_WholeNumberGreaterThanZero_Validator_Js.invokeValidation(element);if("undefined"!=typeof response)element.validationEngine("showPrompt",response,"","topLeft",!0);else {element.validationEngine("hideAll");var pageNumber=self.container.find(".js-page-number"),currentPageNumber=pageNumber.val(),newPageNumber=parseInt($(this).val()),totalPages=parseInt(self.container.find(".js-page--total").text());if(newPageNumber>totalPages){var error=app.vtranslate("JS_PAGE_NOT_EXIST");return void element.validationEngine("showPrompt",error,"","topLeft",!0)}if(newPageNumber==currentPageNumber)return void Vtiger_Helper_Js.showMessage({text:app.vtranslate("JS_YOU_ARE_IN_PAGE_NUMBER")+" "+newPageNumber,type:"info"});pageNumber.val(newPageNumber),self.loadRecordList().done(function(){self.updatePagination();});}}});},/**
		 * Register list search
		 */registerListSearch:function registerListSearch(){this.listSearchInstance=YetiForce_ListSearch_Js.getInstance(this.container,!1,this,this.moduleName),this.listSearchInstance.setViewName("RecordsList");},/**
		 * Register list events
		 */registerListEvents:function registerListEvents(){var self=this,additional=1==this.container.find(".js-additional-informations").val();self.container.on("click",".js-select-row",function(e){if($(e.target).hasClass("js-select-checkbox")||$(e.target).hasClass("u-cursor-auto"))return !0;if(!$(e.target).hasClass("js-no-link")&&!$(e.target).closest("a").hasClass("noLinkBtn")&&!$(e.target).is("a")){var row=$(this),data=row.data();if(self.container.find(".js-multi-select").val()){var selected={};additional?(selected[data.id]=[],row.find("td[data-field]").each(function(index,field){field=$(field),selected[data.id].push({value:field.text(),field:field.data("field"),type:field.data("type")});})):selected[data.id]=data.name,self.selectEvent(selected,e);}else self.selectEvent(data,e);app.hideModalWindow(!1,self.container.parent().attr("id"));}}),self.container.on("click",".js-selected-rows",function(e){var selected={};self.container.find("table tr.js-select-row .js-select-checkbox").each(function(index,element){if(element=$(element),!element.is(":checked"))return !0;var data=element.closest("tr").data();additional?(selected[data.id]=[],element.closest("tr").find("td[data-field]").each(function(index,field){field=$(field),selected[data.id].push({value:field.text(),field:field.data("field"),type:field.data("type")});})):selected[data.id]=data.name;}),0>=Object.keys(selected).length?app.showNotify({text:app.vtranslate("JS_PLEASE_SELECT_ONE_RECORD"),type:"error"}):(self.selectEvent(selected,e),app.hideModalWindow($(e.target).closest(".js-modal-container")));}),self.container.on("change",".js-hierarchy-records",function(){self.container.find(".js-related-parent-id").val(this.value),self.container.find(".js-total-count").val(""),self.container.find(".js-page-number").val(1),self.loadRecordList().done(function(){self.updatePagination();});}),self.container.on("click",".js-select-checkbox",function(){var parentElem,element;parentElem=element=$(this),"all"===element.data("type")&&(parentElem=element.closest("table").find(".js-select-checkbox[data-type=\"row\"]")),element.is(":checked")?parentElem.prop("checked",!0).closest("tr").addClass("highlightBackgroundColor"):parentElem.prop("checked",!1).closest("tr").removeClass("highlightBackgroundColor");});},getFilterSelectElement:function getFilterSelectElement(){return this.container.find("#customFilter")},registerCustomFilter:function registerCustomFilter(){var filterSelectElement=this.getFilterSelectElement();0<filterSelectElement.length&&filterSelectElement.is("select")&&(App.Fields.Picklist.showSelect2ElementView(filterSelectElement,{templateSelection:function templateSelection(data){var resultContainer=document.createElement("span"),span=document.createElement("span"),image=$(".filterImage").detach();return image.removeAttr("style"),span.innerText=data.text,resultContainer.appendChild(image.get(0)),resultContainer.appendChild(span),resultContainer},customSortOptGroup:!0,closeOnSelect:!0}),filterSelectElement.data("select2").$dropdown.append(this.container.find("span.filterActionsDiv")),this.registerChangeCustomFilterEvent(filterSelectElement));},registerChangeCustomFilterEvent:function registerChangeCustomFilterEvent(filterSelectElement){var _this4=this;filterSelectElement.on("change",function(){_this4.loadRecordList({page:1,totalCount:0}).done(function(){_this4.updatePagination();});});},/**
		 * Register modal basic events
		 */registerBasicEvents:function registerBasicEvents(){this.registerListSearch(),this.registerPaginationEvents();},/**
		 * Register modal events
		 * @param {jQuery} modalContainer
		 */registerEvents:function registerEvents(modalContainer){this.container=modalContainer,this.moduleName=this.container.data("module"),this.registerCustomFilter(),this.registerBasicEvents(),this.registerListEvents(),this.registerHeadersClickEvent();}});
//# sourceMappingURL=RecordsList.min.js.map
