<?php
/**
 * Base cli file.
 *
 * @package Cli
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace App\Cli;

use App\Cli;
use League\CLImate\CLImate;

/**
 * Base cli class.
 */
abstract class Base implements CliInterface
{
	/** @var Cli Cli instance. */
	protected Cli $cli;

	/** @var CLImate CLImate instance. */
	protected CLImate $climate;

	/** @var string Module Name */
	protected string $moduleName;

	/** @var bool Show only help info */
	protected bool $helpMode = false;

	/** @var array Cli methods */
	protected array $methods = [];

	/**
	 * Construct.
	 *
	 * @param Cli $cli
	 */
	public function __construct(Cli $cli)
	{
		$this->cli = $cli;
		$this->climate = $cli->climate;
	}

	/**
	 * @inheritdoc
	 */
	public function getModuleName(): string
	{
		return $this->moduleName;
	}

	/**
	 * @inheritdoc
	 */
	public function isHelpMode(): bool
	{
		return $this->helpMode;
	}

	/**
	 * @inheritdoc
	 */
	public function setHelpMode(bool $helpMode): self
	{
		$this->helpMode = $helpMode;

		return $this;
	}

	/**
	 * @inheritdoc
	 */
	public function getMethods(): array
	{
		return $this->methods;
	}

	public function returnToActionList(): void
	{
		$this->cli->actionsList($this->getModuleName());
	}
}
