<?php
/**
 * Developer cli file.
 *
 * @package Cli
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace App\Cli;

use Api\Core\Containers;
use App\ErrorHandler;

/**
 * Developer cli class.
 */
class Developer extends Base
{
	/** {@inheritdoc} */
	public string $moduleName = 'Developer';

	/** {@inheritdoc} */
	protected array $methods = [
		'generateSwagger' => 'Generate interactive OpenAPI documentation',
	];

	/**
	 * Reset user password.
	 *
	 * @return void
	 */
	public function generateSwagger(): void
	{
		$climate = $this->climate;
		set_error_handler(static function ($errNo, $errStr, $errFile, $errLine) use ($climate) {
			$errorString = ErrorHandler::error2string($errNo);
			$climate->lightRed(PHP_EOL . reset($errorString) . ": $errStr\nFile: $errFile\nLine: $errLine");
		}, E_ALL);
		foreach (Containers::LIST as $type) {
			$this->climate->inline($type);
			\App\Installer\Developer::generateSwaggerByType($type, \App\Installer\Developer::PATH, false);
			$this->climate->out(' - generated');
		}
		if (!$this->climate->arguments->defined('action')) {
			$this->returnToActionList();
		}
	}
}
