<?php

/**
 * Csrf exception class.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace App\Exceptions;

use App\Db;
use App\Request;
use App\RequestUtil;
use App\Session;
use App\TextUtils;

class Csrf extends Security
{
	public function __construct($message = '', $code = 0, ?\Exception $previous = null)
	{
		parent::__construct($message, $code, $previous);
		Session::init();
		$userName = Session::get('full_user_name');
		$userName = empty($userName) ? '-' : TextUtils::textTruncate($userName, 100, false);
		Db::getInstance('log')->createCommand()
			->insert('o_#__csrf', [
				'username' => $userName,
				'date' => date('Y-m-d H:i:s'),
				'ip' => TextUtils::textTruncate(RequestUtil::getRemoteIP(), 100, false),
				'referer' => TextUtils::textTruncate(Request::_getServer('HTTP_REFERER', '-'), 300, false),
				'url' => TextUtils::textTruncate(RequestUtil::getBrowserInfo()->url, 300, false),
				'agent' => TextUtils::textTruncate(Request::_getServer('HTTP_USER_AGENT', '-'), 500, false),
			])->execute();
	}
}
