<?php
/**
 * Transform field coordinate into modules and in opposite way
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Leszek Koziatek <l.koziatek@yetiforce.com>
 */
declare(strict_types=1);

namespace App\FieldCoordinatorTransformer;

/** TransformerInterface interface class */
interface TransformerInterface
{
	public static function combine(
		string $fieldName,
		?string $moduleName = null,
		?string $referenceField = null,
		bool $isInventory = false,
	): string;

	/**
	 * Extract field coordination to array
	 *
	 * @param string $fieldCoordinates - String in format %s:%s:%s:%s or shorter
	 * @return array{fieldName: string, moduleName: string, referenceField: ?string, isInventory: bool}
	 */
	public static function extract(string $fieldCoordinates): array;
}
