<?php

/**
 * KSeF Certificate Status enum file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Model\Certificate\Enum;

enum CertificateStatus: string
{
	case Active = 'Active';

	case Blocked = 'Blocked';

	case Revoked = 'Revoked';

	case Expired = 'Expired';

	public function getLabel(): string
	{
		return 'PLL_' . strtoupper($this->value);
	}
}
