<?php
/**
 * KSeF Connection Model class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Model\Connector;

use N1ebieski\KSEFClient\Resources\ClientResource;

/**
 * KSeF Connection Model class.
 */
final class Connection
{
	/** @var Setting|null Connection setting */
	private ?Setting $setting = null;

	/** @var ClientResource|null KSeF API client */
	private ?ClientResource $client = null;


	/**
	 * Get setting.
	 *
	 * @return Setting|null
	 */
	public function getSetting(): ?Setting
	{
		return $this->setting;
	}

	/**
	 * Set setting.
	 *
	 * @param Setting $setting
	 *
	 * @return self
	 */
	public function setSetting(Setting $setting): self
	{
		$this->setting = $setting;
		return $this;
	}

	/**
	 * Get client.
	 *
	 * @return ClientResource|null
	 */
	public function getClient(): ?ClientResource
	{
		return $this->client;
	}

	/**
	 * Set client.
	 *
	 * @param ClientResource $client
	 *
	 * @return self
	 */
	public function setClient(ClientResource $client): self
	{
		$this->client = $client;
		return $this;
	}

	/**
	 * Check if connection is established.
	 *
	 * @return bool
	 */
	public function isConnected(): bool
	{
		return null !== $this->client;
	}
}
