<?php
/**
 * KSeF Mode enum file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Model\Enum;

/**
 * KSeF Mode enum.
 */
enum Mode: int
{
	case ONLINE = 0;              // Online mode
	case OFFLINE = 1;             // Offline mode

	/**
	 * Convert invoicing mode string to Mode enum value.
	 *
	 * @param string $invoicingMode
	 * @param string $mode
	 *
	 * @return int
	 */
	public static function fromString(string $mode): int
	{
		return match (strtolower($mode)) {
			'offline' => self::OFFLINE->value,
			'online' => self::ONLINE->value,
			default => self::ONLINE->value,
		};
	}
}
