<?php
/**
 * KSeF Status enum file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Model\Enum;

/**
 * KSeF Status enum.
 */
enum Status: int
{
	case NEW = 0;
	case IN_PROGRESS = 1;
	case DONE = 2;
	case REJECTED = 3;
	case ERROR = 4;
	case CANCELED = 5;

	/**
	 * Get label for status.
	 *
	 * @return string
	 */
	public function getLabel(): string
	{
		return match ($this) {
			self::NEW => 'LBL_STATUS_NEW',
			self::IN_PROGRESS => 'LBL_STATUS_IN_PROGRESS',
			self::DONE => 'LBL_STATUS_DONE',
			self::REJECTED => 'LBL_STATUS_REJECTED',
			self::ERROR => 'LBL_STATUS_ERROR',
			self::CANCELED => 'LBL_STATUS_CANCELED',
		};
	}
}
