<?php
/**
 * KSeF XmlJob Model class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Model\Reader;

/**
 * KSeF XmlJob Model class.
 */
final class XmlJob
{
	/** @var string|null XML file name */
	private ?string $xmlName = null;

	/** @var string|null XML payload */
	private ?string $xmlPayload = null;

	/** @var string|null Module name */
	private ?string $module = null;

	/**
	 * Get XML name.
	 *
	 * @return string|null
	 */
	public function getXmlName(): ?string
	{
		return $this->xmlName;
	}

	/**
	 * Set XML name.
	 *
	 * @param string|null $xmlName
	 *
	 * @return self
	 */
	public function setXmlName(?string $xmlName): self
	{
		$this->xmlName = $xmlName;
		return $this;
	}

	/**
	 * Get XML payload.
	 *
	 * @return string|null
	 */
	public function getXmlPayload(): ?string
	{
		return $this->xmlPayload;
	}

	/**
	 * Set XML payload.
	 *
	 * @param string|null $xmlPayload
	 *
	 * @return self
	 */
	public function setXmlPayload(?string $xmlPayload): self
	{
		$this->xmlPayload = $xmlPayload;
		return $this;
	}
	
	/**
	 * Set module name.
	 *
	 * @param string|null $module
	 *
	 * @return self
	 */
	public function setModule(?string $module): self
	{
		$this->module = $module;
		return $this;
	}

	/**
	 * Get module name.
	 *
	 * @return string|null
	 */
	public function getModule(): ?string
	{
		return $this->module;
	}
	
}
