<?php
/**
 * KSeF Builder FaAnnotationsRule rule class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Builder\Rules;

use App\Integrations\KSeF\Model\Enum\Type;
use App\Integrations\KSeF\Service\Mapper\MapperService;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\Adnotacje;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\NoweSrodkiTransportu;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\P_19AGroup;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\P_19BGroup;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\P_19CGroup;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\P_19Group;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\P_PMarzy_2Group;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\P_PMarzy_3_1Group;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\P_PMarzy_3_2Group;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\P_PMarzy_3_3Group;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\P_PMarzyGroup;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\PMarzy;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\Zwolnienie;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_16;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_17;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_18;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_18A;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_19;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_19A;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_19B;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_19C;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_23;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_PMarzy;

/**
 * KSeF Builder FaAnnotationsRule rule class.
 */
class FaAnnotationsRule implements RuleInterface
{
	private ?MapperService $mapperService = null;

	/** {@inheritDoc} */
	public function apply(array &$target, MapperService $mapperService): void
	{
		$this->mapperService = $mapperService;

		$p16 = ($this->mapperService->mapField('//Fa/Adnotacje/P_16', Type::BOOL)) ? P_16::MetodaKasowa : P_16::Default;
		$p18 = ($this->mapperService->mapField('//Fa/Adnotacje/P_18', Type::BOOL)) ? P_18::OdwrotneObciazenie : P_18::Default;
		$p18a = ($this->mapperService->mapField('//Fa/Adnotacje/P_18A', Type::BOOL)) ? P_18A::MechanizmPodzielonejPlatnosci : P_18A::Default;
		$annotations = new Adnotacje(
			p_16: $p16,
			p_17: P_17::Default, /* Not implemented yet */
			p_18: $p18,
			p_18A: $p18a,
			zwolnienie: $this->exemption(),
			noweSrodkiTransportu: new NoweSrodkiTransportu(), /* Not implemented yet */
			p_23: P_23::Default, /* Not implemented yet */
			pMarzy: $this->marginProcedure(),
		);

		$target['fa_adnotacje'] = $annotations;
	}

	private function exemption(): Zwolnienie
	{
		$taxExemptionType = $this->mapperService->mapField('//Fa/Adnotacje/Zwolnienie/P_19', Type::STRING);
		$taxExemptionText = $this->mapperService->mapField('//Fa/Adnotacje/Zwolnienie/P_19C', Type::STRING);

		if (!empty($taxExemptionType) && !empty($taxExemptionText)) {
			$exemption = match ($taxExemptionType) {
				'PLL_ACT' => new Zwolnienie(new P_19Group(new P_19AGroup(new P_19A($taxExemptionText), P_19::Default))),
				'PLL_DIRECTIVE' => new Zwolnienie(new P_19Group(new P_19BGroup(new P_19B($taxExemptionText)), P_19::Default)),
				'PLL_OTHER' => new Zwolnienie(new P_19Group(new P_19CGroup(new P_19C($taxExemptionText)), P_19::Default)),
				default => null,
			};
		} else {
			$exemption = new Zwolnienie();
		}

		return $exemption;
	}

	private function marginProcedure(): PMarzy
	{
		$marginProcedure = $this->mapperService->mapField('//Fa/Adnotacje/PMarzy', Type::STRING);
		if (!empty($marginProcedure)) {
			$details = match ($marginProcedure) {
				'PLL_TRAVEL_AGENCIES' => new P_PMarzy_2Group(),
				'PLL_SECOND_HAND_GOODS' => new P_PMarzy_3_1Group(),
				'PLL_WORKS_OF_ART' => new P_PMarzy_3_2Group(),
				'PLL_COLLECTIBLES_AND_ANTIQUES' => new P_PMarzy_3_3Group(),
			};
			$marginProcedure = new PMarzy(
				new P_PMarzyGroup(
					p_PMarzy_2_3Group: $details,
					p_PMarzy: P_PMarzy::Default,
				)
			);
		} else {
			$marginProcedure = new PMarzy();
		}

		return $marginProcedure;
	}
}
