<?php
/**
 * KSeF Builder FaInvoiceTypeRule rule class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Builder\Rules;

use App\Integrations\KSeF\Model\Enum\Type;
use App\Integrations\KSeF\Service\Mapper\MapperService;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\RodzajFaktury;

/**
 * KSeF Builder FaInvoiceTypeRule rule class.
 */
class FaInvoiceTypeRule implements RuleInterface
{
	private ?MapperService $mapperService = null;

	/** {@inheritDoc} */
	public function apply(array &$target, MapperService $mapperService): void
	{
		$this->mapperService = $mapperService;
		$moduleName = $this->mapperService->getRecord()->getModuleName();

		$invoiceType = $this->mapperService->mapField('//Fa/RodzajFaktury', Type::STRING);

		if ('FCorectingInvoice' === $moduleName) {
			$type = match ($invoiceType) {
				'PLL_KOR_ZAL' => RodzajFaktury::KorZal,
				'PLL_KOR_ROZ' => RodzajFaktury::KorRoz,
				default => RodzajFaktury::Kor,
			};
		} else {
			$type = match ($invoiceType) {
				'PLL_ZAL' => RodzajFaktury::Zal,
				'PLL_ROZ' => RodzajFaktury::Roz,
				'PLL_UPR' => RodzajFaktury::Upr,
				default => RodzajFaktury::Vat,
			};
		}

		$target['//Fa/RodzajFaktury'] = $type;
	}
}
