<?php
/**
 * KSeF Builder FooterRule rule class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Builder\Rules;

use App\Integrations\KSeF\Exception\KSeFInvoiceBuilderException;
use App\Integrations\KSeF\Model\Enum\Type;
use App\Integrations\KSeF\Service\Mapper\MapperService;

/**
 * KSeF Builder FooterRule rule class.
 */
class FooterRule implements RuleInterface
{
	/** {@inheritDoc} */
	public function apply(array &$target, MapperService $mapperService): void
	{
		$target['//Stopka/Informacje/StopkaFaktury'] = $mapperService->mapField('//Stopka/Informacje/StopkaFaktury', Type::STRING);
	}
}
