<?php
/**
 * KSeF Builder Rule class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Builder\Rules;

use App\Integrations\KSeF\Service\Mapper\MapperService;

/**
 * KSeF Builder Rule class.
 */
interface RuleInterface
{
	/**
	 * Apply the specific rule to the target array using the provided mapper service.
	 *
	 * @param array         $target        The target array to modify.
	 * @param MapperService $mapperService The mapper service for field mapping.
	 *
	 * @return void
	 */
	public function apply(array &$target, MapperService $mapperService): void;
}
