<?php
/**
 * KSeF Builder Subject1Rule rule class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Builder\Rules;

use App\Fields\Country;
use App\Integrations\KSeF\Exception\KSeFInvoiceBuilderException;
use App\Integrations\KSeF\Model\Enum\Type;
use App\Integrations\KSeF\Service\Mapper\MapperService;

/**
 * KSeF Builder Subject1Rule rule class.
 */
class Subject1Rule implements RuleInterface
{
	/** {@inheritDoc} */
	public function apply(array &$target, MapperService $mapperService): void
	{
		$target['//Podmiot1/DaneIdentyfikacyjne/NIP'] = $mapperService->mapField('//Podmiot1/DaneIdentyfikacyjne/NIP', Type::STRING);
		$target['//Podmiot1/DaneIdentyfikacyjne/Nazwa'] = $mapperService->mapField('//Podmiot1/DaneIdentyfikacyjne/Nazwa', Type::STRING);
		$target['//Podmiot1/Adres/AdresL1'] = $mapperService->mapField('//Podmiot1/Adres/AdresL1', Type::STRING);
		$target['//Podmiot1/Adres/KodKraju'] = Country::getCountryCode($mapperService->mapField('//Podmiot1/Adres/KodKraju', Type::STRING)) ?? 'PL';
		$target['//Podmiot1/DaneKontaktowe/Email'] = $mapperService->mapField('//Podmiot1/DaneKontaktowe/Email', Type::STRING);
		$target['//Podmiot1/DaneKontaktowe/Telefon'] = $mapperService->mapField('//Podmiot1/DaneKontaktowe/Telefon', Type::STRING);
	}
}
