<?php
/**
 * KSeF Builder Subject2Rule rule class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Builder\Rules;

use App\Fields\Country;
use App\Integrations\KSeF\Model\Enum\Type;
use App\Integrations\KSeF\Service\Mapper\MapperService;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\BrakIDGroup;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\KrajGroup;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\NIPGroup;
use N1ebieski\KSEFClient\Support\Optional;
use N1ebieski\KSEFClient\ValueObjects\NIP;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\KodKraju;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\NrID;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\BrakID;

/**
 * KSeF Builder Subject2Rule rule class.
 */
class Subject2Rule implements RuleInterface
{
	/** {@inheritDoc} */
	public function apply(array &$target, MapperService $mapperService): void
	{
		$countryName = $mapperService->mapField('//Podmiot2/Adres/KodKraju', Type::STRING);
		$countryCode = Country::getCountryCode($countryName);
		$nipValue = $mapperService->mapField('//Podmiot2/DaneIdentyfikacyjne/NIP', Type::STRING);

		$isPolishNIP = !empty($nipValue) && preg_match('/^\d{10}$/', $nipValue);

		if ($isPolishNIP) {
			$target['//Podmiot2/DaneIdentyfikacyjne/NIP'] = new NIPGroup(new NIP($nipValue));
		} elseif (!empty($nipValue)) {
			$target['//Podmiot2/DaneIdentyfikacyjne/NIP'] = new KrajGroup(
				new NrID($nipValue),
				!empty($countryCode) ? new KodKraju($countryCode) : new Optional()
			);
		} else {
			$target['//Podmiot2/DaneIdentyfikacyjne/NIP'] = new BrakIDGroup(BrakID::Default);
		}

		$target['//Podmiot2/DaneIdentyfikacyjne/Nazwa'] = $mapperService->mapField('//Podmiot2/DaneIdentyfikacyjne/Nazwa', Type::STRING);
		$target['//Podmiot2/Adres/AdresL1'] = $mapperService->mapField('//Podmiot2/Adres/AdresL1', Type::STRING);
		$target['//Podmiot2/Adres/KodKraju'] = $countryCode ?? 'PL';
		$target['//Podmiot2/DaneKontaktowe/Email'] = $mapperService->mapField('//Podmiot2/DaneKontaktowe/Email', Type::STRING);
		$target['//Podmiot2/DaneKontaktowe/Telefon'] = $mapperService->mapField('//Podmiot2/DaneKontaktowe/Telefon', Type::STRING);
		$target['//Podmiot2/NrKlienta'] = $mapperService->mapField('//Podmiot2/NrKlienta', Type::STRING);
	}
}
