<?php
/**
 * KSeF Invoice Subject1 Builder class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Builder;

use N1ebieski\KSEFClient\DTOs\Requests\Sessions\Adres;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\DaneKontaktowe;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\Podmiot1;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\Podmiot1DaneIdentyfikacyjne;
use N1ebieski\KSEFClient\Support\Optional;
use N1ebieski\KSEFClient\ValueObjects\NIP;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\AdresL1;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\Email;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\KodKraju;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\Nazwa;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\Telefon;

/**
 * KSeF Invoice Subject1 Builder class.
 */
final class Subject1Builder extends AbstractBuilder
{
	/** {@inheritDoc} */
	public function build(): Podmiot1
	{
		return new Podmiot1(
			daneIdentyfikacyjne: new Podmiot1DaneIdentyfikacyjne(
				$this->buildValue(NIP::class, '//Podmiot1/DaneIdentyfikacyjne/NIP'),
				$this->buildValue(Nazwa::class, '//Podmiot1/DaneIdentyfikacyjne/Nazwa'),
			),
			adres: new Adres(
				$this->buildValue(AdresL1::class, '//Podmiot1/Adres/AdresL1'),
				$this->buildValue(KodKraju::class, '//Podmiot1/Adres/KodKraju'),
			),
			daneKontaktowe: [
				new DaneKontaktowe(
					$this->buildValue(Email::class, '//Podmiot1/DaneKontaktowe/Email', new Optional()),
					$this->buildValue(Telefon::class, '//Podmiot1/DaneKontaktowe/Telefon', new Optional()),
				)
			],
		);
	}
}
